/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.OSEnvironment;
import org.apache.log4j.Logger;

public class EnvCommandline
extends Commandline {
    private static final Logger LOG = Logger.getLogger(EnvCommandline.class);
    private OSEnvironment env = new OSEnvironment();

    public EnvCommandline(String command) {
        super(command);
    }

    public EnvCommandline() {
    }

    public void setVariable(String var, String value) {
        this.env.add(var, value);
    }

    public String getVariable(String var) {
        return this.env.getVariable(var);
    }

    public Process execute() throws IOException {
        Process process;
        File workingDir = this.getWorkingDir();
        if (workingDir == null) {
            LOG.debug((Object)("Executing \"" + this + "\""));
            process = Runtime.getRuntime().exec(this.getCommandline(), this.env.toArray());
        } else {
            LOG.debug((Object)("Executing \"" + this + "\" in directory " + workingDir.getAbsolutePath()));
            process = Runtime.getRuntime().exec(this.getCommandline(), this.env.toArray(), workingDir);
        }
        process.getOutputStream().close();
        return process;
    }
}

