/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.File;
import net.sourceforge.cruisecontrol.CruiseControlException;

public class Directory {
    private File directory;

    public void validate() throws CruiseControlException {
        if (this.directory == null) {
            throw new DirectoryNotSpecifiedException("directory");
        }
        if (!this.exists()) {
            throw new DirectoryDoesNotExistException();
        }
        if (!this.isDirectory()) {
            throw new FileInsteadOfDirectoryException();
        }
    }

    public boolean exists() {
        return this.directory.exists();
    }

    public boolean isDirectory() {
        return this.directory.exists();
    }

    public void setPath(String path) {
        this.directory = new File(path);
    }

    public File toFile() {
        return this.directory;
    }

    public static class DirectoryNotSpecifiedException
    extends CruiseControlException {
        public DirectoryNotSpecifiedException(String attributeName) {
            super(attributeName + " must be specified");
        }
    }

    public class FileInsteadOfDirectoryException
    extends CruiseControlException {
        FileInsteadOfDirectoryException() {
            super(Directory.this.directory.getPath() + " is a file instead of a directory");
        }
    }

    public class DirectoryDoesNotExistException
    extends CruiseControlException {
        DirectoryDoesNotExistException() {
            super(Directory.this.directory.getPath() + " does not exist");
        }
    }
}

