/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Logger;

public final class CommandlineUtil {
    private static final Logger LOG = Logger.getLogger(CommandlineUtil.class);

    private CommandlineUtil() {
    }

    public static InputStream streamOutput(Commandline command) {
        try {
            Process p = command.execute();
            WarningConsumer consumer = new WarningConsumer(LOG);
            StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), consumer);
            new Thread(errorPumper).start();
            return new ProcessStreamWrapper(p);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in executing the command : ", (Throwable)e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private static final class ProcessStreamWrapper
    extends FilterInputStream {
        private Process process;

        public ProcessStreamWrapper(Process process) {
            super(process.getInputStream());
            this.process = process;
        }

        public void close() throws IOException {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                InterruptedIOException ioe = new InterruptedIOException();
                ioe.initCause(e);
                throw ioe;
            }
            this.process.getInputStream().close();
            this.process.getOutputStream().close();
            this.process.getErrorStream().close();
        }
    }

    private static final class WarningConsumer
    implements StreamConsumer {
        private final Logger log;

        private WarningConsumer(Logger log) {
            this.log = log;
        }

        public void consumeLine(String line) {
            this.log.warn((Object)line);
        }
    }
}

