/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.Processes;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import org.apache.log4j.Logger;

public class CommandExecutor {
    private static final Logger LOG = Logger.getLogger(CommandExecutor.class);
    private StreamConsumer error = StreamLogger.getWarnLogger(LOG);
    private StreamConsumer output = StreamLogger.getInfoLogger(LOG);
    private final Commandline command;

    public CommandExecutor(Commandline command) {
        this.command = command;
    }

    public CommandExecutor(Commandline command, Logger log) {
        this(command);
        this.logErrorStreamTo(log);
        this.logOutputStreamTo(log);
    }

    public void logErrorStreamTo(Logger log) {
        this.error = StreamLogger.getWarnLogger(log);
    }

    public void logOutputStreamTo(Logger log) {
        this.output = StreamLogger.getInfoLogger(log);
    }

    public void setOutputConsumer(StreamConsumer outConsumer) {
        this.output = outConsumer;
    }

    public void executeAndWait() throws CruiseControlException {
        int exitValue;
        LOG.debug((Object)("Executing " + this.command.getExecutable()));
        try {
            exitValue = Processes.waitFor(this.command.execute(), this.output, this.error);
        }
        catch (Exception e) {
            throw new CruiseControlException(this.command.getExecutable() + " failed with exception", e);
        }
        if (exitValue != 0) {
            throw new CruiseControlException(this.command.getExecutable() + " process exited with error code " + exitValue);
        }
    }
}

