/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.util.StreamConsumer;

public class BuildOutputLogger
implements StreamConsumer {
    public static final int MAX_LINES = 1000;
    private File data;

    public BuildOutputLogger(File outputFile) {
        this.data = outputFile;
    }

    public void clear() {
        if (this.noDataFile()) {
            return;
        }
        this.data.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumeLine(String line) {
        if (this.data == null) {
            throw new RuntimeException("No log file specified");
        }
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(this.data, true));
            out.println(line);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String[] retrieveLines(int firstLine) {
        if (this.noDataFile()) {
            return new String[0];
        }
        List lines = this.loadFile(firstLine);
        return lines.toArray(new String[lines.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadFile(int firstLine) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.data));
            this.skipLines(reader, firstLine);
            List list = this.readUptoMaxLines(reader);
            return list;
        }
        catch (IOException e) {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private List readUptoMaxLines(BufferedReader reader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null && result.size() < 1000) {
            result.add(line);
            line = reader.readLine();
        }
        return result;
    }

    private void skipLines(BufferedReader inFile, int numToSkip) throws IOException {
        for (int i = 0; i < numToSkip; ++i) {
            inFile.readLine();
        }
    }

    private boolean noDataFile() {
        return this.data == null || !this.data.exists();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((BuildOutputLogger)other);
    }

    private boolean equals(BuildOutputLogger other) {
        return this.dataEquals(this.data, other.data);
    }

    private boolean dataEquals(File mine, File other) {
        if (mine == null) {
            return other == null;
        }
        boolean pathSame = mine.getPath().equals(other.getPath());
        boolean nameSame = mine.getName().equals(other.getName());
        return pathSame && nameSame;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public String toString() {
        String path = this.data == null ? "null" : this.data.getAbsolutePath();
        return "<BuildOutputLogger data=" + path + ">";
    }
}

