/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols.accurev;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.KeywordTimespec;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.Timespec;
import org.apache.log4j.Logger;

public class DateTimespec
extends Timespec {
    private static final Logger LOG = Logger.getLogger(DateTimespec.class);
    private static final String DATETIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final KeywordTimespec NOW = new KeywordTimespec("now");
    private Date date;

    public DateTimespec(Date date) {
        this.date = date;
    }

    public DateTimespec(int secondsFromNow) {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, secondsFromNow);
        this.date = calendar.getTime();
    }

    public String format() {
        if (this.date == null) {
            return "";
        }
        return new SimpleDateFormat(DATETIME_FORMAT).format(this.date);
    }

    public static Date parse(String date) {
        try {
            return new SimpleDateFormat(DATETIME_FORMAT).parse(date);
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing date " + date + " using format" + DATETIME_FORMAT));
            return null;
        }
    }
}

