/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols.accurev;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.sourcecontrols.Accurev;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevCommand;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevInputParser;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.Runner;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.Timespec;
import net.sourceforge.cruisecontrol.util.EnvCommandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import org.apache.log4j.Logger;

public class AccurevCommandline
extends EnvCommandline
implements AccurevInputParser,
Runner {
    private static final Logger LOG = Logger.getLogger(Accurev.class);
    private boolean verbose;
    private int runCount;
    private int returnCode;
    private AccurevCommand command;
    private AccurevInputParser inputParser = this;
    private static final int SUCCESS = 0;
    private boolean syntaxError;
    private Runner runner = this;

    public AccurevCommandline(AccurevCommand command) {
        super("accurev");
        this.command = command;
        this.createArgument().setValue(command.toString());
    }

    public void setStream(String stream) {
        this.addOption("-s", stream);
    }

    public void setDepot(String depot) {
        this.addOption("-d", depot);
    }

    public void setComment(String comment) {
        this.addOption("-c", comment);
    }

    public void setInfoOnly() {
        this.addArgument("-i");
    }

    public void setTransactionRange(Timespec time) {
        this.addOption("-t", time.toString());
    }

    public void setTransactionRange(Timespec begin, Timespec end) {
        StringBuffer buf = new StringBuffer();
        if (begin != null) {
            buf.append(begin);
        }
        buf.append("-");
        if (end != null) {
            buf.append(end);
        }
        this.addOption("-t", buf.toString());
    }

    public void setFormatExpanded(char format) throws CruiseControlException {
        if ("evstx".indexOf(format) < 0) {
            throw new CruiseControlException("Invalid format specifier (use one of 'e' 'v' 's' 't' 'x') " + format);
        }
        this.addOption("-f", new String(new char[]{format}));
    }

    public void addArgument(String argument) {
        this.createArgument().setValue(argument);
    }

    public void setInputParser(AccurevInputParser inputParser) {
        this.inputParser = inputParser;
    }

    public void addOption(String option, String optionArgument) {
        this.createArgument().setValue(option);
        this.createArgument().setValue(optionArgument);
    }

    public void selectModified() {
        this.addArgument("-m");
    }

    public void setFileList(String filelistName) {
        this.addOption("-l", filelistName);
    }

    public void setWorkspaceLocalPath(File workspace) throws CruiseControlException {
        this.setWorkingDirectory(workspace.getAbsolutePath());
    }

    public void setWorkspaceLocalPath(String workspace) throws CruiseControlException {
        this.setWorkingDirectory(workspace);
    }

    public void run() {
        if (this.verbose) {
            LOG.info((Object)("Accurev: Executing '" + this.toString() + "'"));
        }
        this.syntaxError = this.runner.execute(this.inputParser);
        this.returnCode = this.runner.getReturnCode();
        ++this.runCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(AccurevInputParser inputParser) {
        boolean error = false;
        try {
            Process proc = super.execute();
            Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, proc));
            stderr.start();
            InputStream input = proc.getInputStream();
            try {
                if (inputParser != null) {
                    error = !inputParser.parseStream(input);
                }
                this.returnCode = proc.waitFor();
                stderr.join();
            }
            finally {
                IO.close(proc);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (CruiseControlException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return error;
    }

    protected String[] buildCommandLine() {
        return null;
    }

    public boolean parseStream(InputStream iStream) throws CruiseControlException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(iStream));
        boolean badSyntax = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("AccuRev was unable to understand your command.")) {
                    badSyntax = true;
                }
                if (!this.verbose) continue;
                LOG.info((Object)line);
            }
        }
        catch (IOException ex) {
            throw new CruiseControlException("Error reading input");
        }
        return !badSyntax;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public AccurevCommand getCommand() {
        return this.command;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSuccess() {
        return this.runCount > 0 && !this.syntaxError && this.returnCode == 0;
    }

    public void assertSuccess() throws CruiseControlException {
        if (!this.isSuccess()) {
            throw new CruiseControlException("Error running " + this.toString());
        }
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }
}

