/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class VssJournal
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(VssJournal.class);
    private String dateFormat = "MM/dd/yy";
    private String timeFormat = "hh:mma";
    private SimpleDateFormat vssDateTimeFormat;
    private boolean overridenDateFormat = false;
    private String ssDir = "$/";
    private String journalFile;
    private SourceControlProperties properties = new SourceControlProperties();
    private Date lastBuild;
    private ArrayList modifications = new ArrayList();

    public VssJournal() {
        this.constructVssDateTimeFormat();
    }

    public void setSsDir(String s) {
        StringBuffer sb = new StringBuffer();
        if (!s.startsWith("$")) {
            sb.append("$");
        }
        if (s.endsWith("/")) {
            sb.append(s.substring(0, s.length() - 1));
        } else {
            sb.append(s);
        }
        this.ssDir = sb.toString();
    }

    public void setJournalFile(String journalFile) {
        this.journalFile = journalFile;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
        this.overridenDateFormat = true;
        this.constructVssDateTimeFormat();
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
        this.constructVssDateTimeFormat();
    }

    private void constructVssDateTimeFormat() {
        this.vssDateTimeFormat = new SimpleDateFormat(this.dateFormat + " " + this.timeFormat, Locale.US);
    }

    protected void setLastBuildDate(Date lastBuild) {
        this.lastBuild = lastBuild;
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.journalFile, "journalfile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.ssDir, "ssdir", this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModifications(Date lastBuild, Date now) {
        this.lastBuild = lastBuild;
        this.modifications.clear();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.journalFile));
            try {
                String s = br.readLine();
                while (s != null) {
                    ArrayList<String> entry = new ArrayList<String>();
                    entry.add(s);
                    s = br.readLine();
                    while (s != null && !s.equals("")) {
                        entry.add(s);
                        s = br.readLine();
                    }
                    Modification mod = this.handleEntry(entry);
                    if (mod != null) {
                        this.modifications.add(mod);
                    }
                    if (!"".equals(s)) continue;
                    s = br.readLine();
                }
            }
            finally {
                IO.close(br);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
        if (this.modifications.size() > 0) {
            this.properties.modificationFound();
        }
        LOG.info((Object)("Found " + this.modifications.size() + " modified files"));
        return this.modifications;
    }

    protected Modification handleEntry(List historyEntry) {
        Modification mod = new Modification("vss");
        String nameAndDateLine = (String)historyEntry.get(2);
        mod.userName = this.parseUser(nameAndDateLine);
        mod.modifiedTime = this.parseDate(nameAndDateLine);
        String folderLine = (String)historyEntry.get(0);
        String fileLine = (String)historyEntry.get(3);
        boolean setPropertyOnDelete = false;
        if (!this.isInSsDir(folderLine)) {
            return null;
        }
        if (this.isBeforeLastBuild(mod.modifiedTime)) {
            return null;
        }
        if (fileLine.startsWith("Labeled")) {
            return null;
        }
        if (fileLine.startsWith("Checked in")) {
            String fileName = this.substringFromLastSlash(folderLine);
            String folderName = this.substringToLastSlash(folderLine);
            Modification.ModifiedFile modfile = mod.createModifiedFile(fileName, folderName);
            modfile.action = "checkin";
            mod.comment = this.parseComment(historyEntry);
        } else if (fileLine.indexOf(" renamed to ") > -1) {
            setPropertyOnDelete = this.deleteModification(historyEntry, mod, fileLine, folderLine);
        } else if (fileLine.indexOf(" moved to ") > -1) {
            setPropertyOnDelete = this.deleteModification(historyEntry, mod, fileLine, folderLine);
        } else {
            String fileName = fileLine.substring(0, fileLine.lastIndexOf(" "));
            Modification.ModifiedFile modfile = mod.createModifiedFile(fileName, folderLine);
            mod.comment = this.parseComment(historyEntry);
            if (fileLine.endsWith("added")) {
                modfile.action = "add";
            } else if (fileLine.endsWith("deleted")) {
                modfile.action = "delete";
                setPropertyOnDelete = true;
            } else if (fileLine.endsWith("recovered")) {
                modfile.action = "recover";
            } else if (fileLine.endsWith("shared")) {
                modfile.action = "branch";
            }
        }
        if (setPropertyOnDelete) {
            this.properties.deletionFound();
        }
        return mod;
    }

    private boolean deleteModification(List historyEntry, Modification mod, String fileLine, String folderLine) {
        mod.comment = this.parseComment(historyEntry);
        String fileName = fileLine.substring(0, fileLine.indexOf(" "));
        Modification.ModifiedFile modfile = mod.createModifiedFile(fileName, folderLine);
        modfile.action = "delete";
        return true;
    }

    private String parseComment(List a) {
        StringBuffer comment = new StringBuffer();
        for (int i = 4; i < a.size(); ++i) {
            comment.append(a.get(i)).append(" ");
        }
        return comment.toString().trim();
    }

    public Date parseDate(String nameAndDateLine) {
        int indexOfColon;
        String dateString = nameAndDateLine.substring(nameAndDateLine.indexOf("Date:") + 5, nameAndDateLine.indexOf("Time:")).trim();
        String timeString = nameAndDateLine.substring(nameAndDateLine.indexOf("Time:") + 5).trim();
        if (!this.overridenDateFormat && (indexOfColon = dateString.indexOf("/:")) != -1) {
            dateString = dateString.substring(0, indexOfColon) + dateString.substring(indexOfColon, indexOfColon + 2).replace(':', '0') + dateString.substring(indexOfColon + 2);
        }
        StringBuffer dateToParse = new StringBuffer();
        dateToParse.append(dateString);
        dateToParse.append(" ");
        dateToParse.append(timeString);
        if (!this.overridenDateFormat) {
            dateToParse.append("m");
        }
        try {
            return this.vssDateTimeFormat.parse(dateToParse.toString());
        }
        catch (ParseException pe) {
            LOG.error((Object)("Could not parse date in VssJournal file : " + dateToParse.toString()), (Throwable)pe);
            return null;
        }
    }

    public String parseUser(String userLine) {
        int startOfUserName = 6;
        try {
            return userLine.substring(6, userLine.indexOf("Date: ") - 1).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error((Object)("Unparsable string was: " + userLine));
            throw e;
        }
    }

    public String substringFromLastSlash(String input) {
        int lastSlashPos = input.lastIndexOf("/");
        if (lastSlashPos > 0 && lastSlashPos + 1 <= input.length()) {
            return input.substring(lastSlashPos + 1);
        }
        return input;
    }

    public String substringToLastSlash(String input) {
        int lastSlashPos = input.lastIndexOf("/");
        if (lastSlashPos > 0) {
            return input.substring(0, lastSlashPos);
        }
        return input;
    }

    protected boolean isInSsDir(String path) {
        boolean isInDir = path.toLowerCase().startsWith(this.ssDir.toLowerCase());
        if (isInDir && !this.ssDir.equalsIgnoreCase(path) && '/' != path.charAt(this.ssDir.length()) && !"$/".equalsIgnoreCase(this.ssDir)) {
            isInDir = false;
        }
        return isInDir;
    }

    protected boolean isBeforeLastBuild(Date date) {
        return date.before(this.lastBuild);
    }
}

