/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.sourcecontrols.VSSHelper;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vss
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(Vss.class);
    private SimpleDateFormat vssDateTimeFormat;
    private String ssDir;
    private String vssPath;
    private String serverPath;
    private String login;
    private String dateFormat = "MM/dd/yy";
    private String timeFormat = "hh:mma";
    private final SourceControlProperties properties = new SourceControlProperties();

    public Vss() {
        this.constructVssDateTimeFormat();
    }

    public void setVsspath(String vsspath) {
        this.vssPath = "$" + vsspath;
    }

    public void setSsDir(String ssdir) {
        this.ssDir = ssdir;
    }

    public void setServerPath(String dirWithSrcsafeIni) {
        this.serverPath = dirWithSrcsafeIni;
    }

    public void setLogin(String usernameCommaPassword) {
        this.login = usernameCommaPassword;
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    public void setPropertyOnDelete(String propertyName) {
        this.properties.assignPropertyOnDeleteName(propertyName);
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
        this.constructVssDateTimeFormat();
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
        this.constructVssDateTimeFormat();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.vssPath, "vsspath", this.getClass());
        ValidationHelper.assertIsSet((Object)this.login, "login", this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        ArrayList<Modification> modifications;
        block6: {
            modifications = new ArrayList<Modification>();
            Process p = null;
            try {
                LOG.info((Object)("Getting modifications for " + this.vssPath));
                p = Runtime.getRuntime().exec(this.getCommandLine(lastBuild, now), VSSHelper.loadVSSEnvironment(this.serverPath));
                p.getOutputStream().close();
                Thread stderr = this.logErrorStream(p.getErrorStream());
                p.waitFor();
                stderr.join();
                this.parseTempFile(modifications);
                if (p == null) break block6;
            }
            catch (Exception e) {
                LOG.error((Object)"Problem occurred while attempting to get VSS modifications.  Returning empty modifications.", (Throwable)e);
                List<Modification> list = Collections.emptyList();
                return list;
            }
            IO.close(p);
            break block6;
            finally {
                if (p != null) {
                    IO.close(p);
                }
            }
        }
        if (modifications.size() <= 0) return modifications;
        this.properties.modificationFound();
        return modifications;
    }

    private Thread logErrorStream(InputStream is) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, is));
        stderr.start();
        return stderr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseTempFile(List<Modification> modifications) throws IOException, CruiseControlException {
        File tempFile = this.getTempFile();
        if (!this.getTempFile().isFile()) {
            throw new CruiseControlException("vss failed to create output file " + tempFile.getPath());
        }
        if (LOG.isDebugEnabled()) {
            this.logVSSTempFile();
        }
        BufferedReader reader = new BufferedReader(new FileReader(tempFile));
        try {
            this.parseHistoryEntries(modifications, reader);
        }
        finally {
            reader.close();
        }
        tempFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logVSSTempFile() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.getTempFile()));
        try {
            String currLine = reader.readLine();
            LOG.debug((Object)" ");
            while (currLine != null) {
                LOG.debug((Object)(this.getTempFile().getName() + ": " + currLine));
                currLine = reader.readLine();
            }
            LOG.debug((Object)" ");
        }
        finally {
            reader.close();
        }
    }

    private File getTempFile() {
        return new File(this.createFileNameFromVssPath());
    }

    String createFileNameFromVssPath() {
        String filename = this.vssPath.substring(1).replace('/', '_') + ".tmp";
        while (filename.charAt(0) == '_') {
            filename = filename.substring(1);
        }
        if (".tmp".equals(filename)) {
            filename = "vssroot" + filename;
        }
        return filename;
    }

    void parseHistoryEntries(List<Modification> modifications, BufferedReader reader) throws IOException {
        String currLine = reader.readLine();
        while (currLine != null) {
            if (this.isRelevantVssEntryHeader(currLine)) {
                ArrayList<String> vssEntry = new ArrayList<String>();
                vssEntry.add(currLine);
                currLine = reader.readLine();
                while (currLine != null && !this.isRelevantVssEntryHeader(currLine)) {
                    vssEntry.add(currLine);
                    currLine = reader.readLine();
                }
                Modification mod = this.handleEntry(vssEntry);
                if (mod == null) continue;
                modifications.add(mod);
                continue;
            }
            currLine = reader.readLine();
        }
    }

    private boolean isRelevantVssEntryHeader(String line) {
        return line.matches("\\*+ {2}.+ {2}\\*+");
    }

    protected String[] getCommandLine(Date lastBuild, Date now) throws IOException {
        Commandline commandline = new Commandline();
        String execCommand = this.ssDir != null ? new File(this.ssDir, "ss.exe").getCanonicalPath() : "ss.exe";
        commandline.setExecutable(execCommand);
        commandline.createArgument("history");
        commandline.createArgument(this.vssPath);
        commandline.createArgument("-R");
        commandline.createArgument("-Vd" + this.formatDateForVSS(now) + "~" + this.formatDateForVSS(lastBuild));
        commandline.createArgument("-Y" + this.login);
        commandline.createArgument("-I-N");
        commandline.createArgument("-O" + this.getTempFile().getName());
        LOG.info((Object)("Command line to execute: " + commandline));
        return commandline.getCommandline();
    }

    private String formatDateForVSS(Date date) {
        String vssFormattedDate = new SimpleDateFormat(this.dateFormat + ";" + this.timeFormat, Locale.US).format(date);
        if (this.timeFormat.endsWith("a")) {
            return vssFormattedDate.substring(0, vssFormattedDate.length() - 1);
        }
        return vssFormattedDate;
    }

    protected Modification handleEntry(List<String> entry) {
        String nameAndDateLine;
        LOG.debug((Object)"VSS history entry BEGIN");
        for (String anEntry : entry) {
            LOG.debug((Object)("entry: " + anEntry));
        }
        LOG.debug((Object)"VSS history entry END");
        String labelDelimiter = "**********************";
        boolean isLabelEntry = "**********************".equals(entry.get(0));
        if (isLabelEntry) {
            LOG.debug((Object)"this is a label; ignoring this entry");
            return null;
        }
        int nameAndDateIndex = 2;
        if (entry.get(0).startsWith("***************** ")) {
            nameAndDateIndex = 1;
        }
        if ((nameAndDateLine = entry.get(nameAndDateIndex)).startsWith("Label:")) {
            nameAndDateLine = entry.get(++nameAndDateIndex);
            LOG.debug((Object)"adjusting for the line that starts with Label");
        }
        Modification modification = new Modification("vss");
        modification.userName = this.parseUser(nameAndDateLine);
        modification.modifiedTime = this.parseDate(nameAndDateLine);
        String folderLine = entry.get(0);
        int fileIndex = nameAndDateIndex + 1;
        String fileLine = entry.get(fileIndex);
        LOG.debug((Object)("File line is: " + fileLine));
        if (fileLine.startsWith("Checked in")) {
            LOG.debug((Object)"this is a checkin");
            int commentIndex = fileIndex + 1;
            modification.comment = this.parseComment(entry, commentIndex);
            String fileName = folderLine.substring(7, folderLine.indexOf("  *"));
            String folderName = fileLine.substring(12);
            Modification.ModifiedFile modfile = modification.createModifiedFile(fileName, folderName);
            modfile.action = "checkin";
        } else if (fileLine.endsWith("Created")) {
            modification.type = "create";
            LOG.debug((Object)"this folder was created");
        } else {
            String fileName;
            String folderName = nameAndDateIndex == 1 ? this.vssPath : this.vssPath + "\\" + folderLine.substring(7, folderLine.indexOf("  *"));
            int lastSpace = fileLine.lastIndexOf(" ");
            if (lastSpace != -1) {
                fileName = fileLine.substring(0, lastSpace);
            } else {
                fileName = fileLine;
                if (fileName.equals("Branched")) {
                    LOG.debug((Object)"Branched file, ignoring as branch directory is handled separately");
                    return null;
                }
            }
            Modification.ModifiedFile modfile = modification.createModifiedFile(fileName, folderName);
            if (fileLine.endsWith("added")) {
                modfile.action = "add";
            } else if (fileLine.endsWith("deleted")) {
                modfile.action = "delete";
                this.properties.deletionFound();
            } else if (fileLine.endsWith("destroyed")) {
                modfile.action = "destroy";
                this.properties.deletionFound();
            } else if (fileLine.endsWith("recovered")) {
                modfile.action = "recover";
            } else if (fileLine.endsWith("shared")) {
                modfile.action = "share";
            } else if (fileLine.endsWith("branched")) {
                modfile.action = "branch";
            } else if (fileLine.indexOf(" renamed to ") != -1) {
                modfile.fileName = fileLine;
                modfile.action = "rename";
                this.properties.deletionFound();
            } else {
                if (fileLine.startsWith("Labeled")) {
                    return null;
                }
                LOG.warn((Object)("Don't know how to handle this line: " + fileLine));
                return null;
            }
        }
        return modification;
    }

    private String parseComment(List commentList, int commentIndex) {
        StringBuilder comment = new StringBuilder();
        comment.append(commentList.get(commentIndex)).append(" ");
        for (int i = commentIndex + 1; i < commentList.size(); ++i) {
            comment.append(commentList.get(i)).append(" ");
        }
        return comment.toString().trim();
    }

    public Date parseDate(String nameAndDateLine) {
        String dateAndTime = nameAndDateLine.substring(nameAndDateLine.indexOf("Date: "));
        int indexOfColon = dateAndTime.indexOf("/:");
        if (indexOfColon != -1) {
            dateAndTime = dateAndTime.substring(0, indexOfColon) + dateAndTime.substring(indexOfColon, indexOfColon + 2).replace(':', '0') + dateAndTime.substring(indexOfColon + 2);
        }
        try {
            Date lastModifiedDate = this.timeFormat.endsWith("a") ? this.vssDateTimeFormat.parse(dateAndTime.trim() + "m") : this.vssDateTimeFormat.parse(dateAndTime.trim());
            return lastModifiedDate;
        }
        catch (ParseException pe) {
            LOG.warn((Object)"Could not parse date", (Throwable)pe);
            return null;
        }
    }

    public String parseUser(String userLine) {
        int userIndex = "User: ".length();
        return userLine.substring(userIndex, userLine.indexOf("Date: ") - 1).trim();
    }

    private void constructVssDateTimeFormat() {
        this.vssDateTimeFormat = new SimpleDateFormat("'Date: '" + this.dateFormat + "   'Time: '" + this.timeFormat, Locale.US);
    }

    protected SimpleDateFormat getVssDateTimeFormat() {
        return this.vssDateTimeFormat;
    }
}

