/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Store
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(Store.class);
    private static final String STORE_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS";
    private final SourceControlProperties properties = new SourceControlProperties();
    private String workingDirectory;
    private String script;
    private String profile;
    private List packages;
    private String versionRegex;
    private String minimumBlessingLevel;
    private String parcelBuilderFile;

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setWorkingDirectory(String directory) {
        this.workingDirectory = directory;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setPackages(String packageNames) {
        if (packageNames != null) {
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            this.packages = new ArrayList();
            while (st.hasMoreTokens()) {
                this.packages.add(st.nextToken());
            }
        }
    }

    public void setVersionRegex(String regex) {
        this.versionRegex = regex;
    }

    public void setMinimumBlessingLevel(String blessing) {
        this.minimumBlessingLevel = blessing;
    }

    public void setParcelBuilderFile(String filename) {
        this.parcelBuilderFile = filename;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.workingDirectory != null, "'workingDirectory is a required attribute on the Store task");
        if (this.workingDirectory != null) {
            File directory = new File(this.workingDirectory);
            ValidationHelper.assertTrue(directory.exists() && directory.isDirectory(), "'workingDirectory' must be an existing directory. Was " + directory.getAbsolutePath());
        }
        ValidationHelper.assertTrue(this.script != null, "'script' is a required attribute on the Store task");
        if (this.script != null) {
            File scriptFile = new File(this.script);
            ValidationHelper.assertTrue(scriptFile.exists(), "'script' must be an existing file. Was " + scriptFile.getAbsolutePath());
        }
        ValidationHelper.assertTrue(this.profile != null, "'profile' is a required attribute on the Store task");
        ValidationHelper.assertTrue(this.packages != null, "'packages' is a required attribute on the Store task");
        ValidationHelper.assertTrue(this.packages.size() > 0, "'packages' must specify at least one package");
    }

    public List getModifications(Date lastBuild, Date now) {
        Commandline command;
        List modifications = new ArrayList();
        try {
            command = this.buildCommand(lastBuild, now);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Error building history command", (Throwable)e);
            return modifications;
        }
        try {
            modifications = this.execCommand(command);
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing svn log command " + command), (Throwable)e);
        }
        this.fillPropertiesIfNeeded(modifications);
        return modifications;
    }

    Commandline buildCommand(Date lastBuild, Date checkTime) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(this.workingDirectory);
        command.setExecutable(this.script);
        command.createArguments("-profile", this.profile);
        command.createArgument("-packages");
        Iterator iterator = this.packages.iterator();
        while (iterator.hasNext()) {
            command.createArgument((String)iterator.next());
        }
        if (this.versionRegex != null) {
            command.createArguments("-versionRegex", this.versionRegex);
        }
        if (this.minimumBlessingLevel != null) {
            command.createArguments("-blessedAtLeast", this.minimumBlessingLevel);
        }
        command.createArguments("-lastBuild", Store.formatDate(lastBuild));
        command.createArguments("-now", Store.formatDate(checkTime));
        if (this.parcelBuilderFile != null) {
            command.createArguments("-parcelBuilderFile", this.parcelBuilderFile);
        }
        command.createArgument("-check");
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    static String formatDate(Date date) {
        return Store.getDateFormatter().format(date);
    }

    private List execCommand(Commandline command) throws InterruptedException, IOException, ParseException, JDOMException {
        Process p = command.execute();
        Thread stderr = Store.logErrorStream(p);
        InputStream storeStream = p.getInputStream();
        List modifications = this.parseStream(storeStream);
        p.waitFor();
        stderr.join();
        IO.close(p);
        return modifications;
    }

    private static Thread logErrorStream(Process p) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p.getErrorStream()));
        stderr.start();
        return stderr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List parseStream(InputStream storeStream) throws JDOMException, IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(storeStream, "UTF-8");
        try {
            List list = StoreLogXMLParser.parse(reader);
            return list;
        }
        finally {
            reader.close();
        }
    }

    void fillPropertiesIfNeeded(List modifications) {
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
        }
    }

    public static DateFormat getDateFormatter() {
        SimpleDateFormat f = new SimpleDateFormat(STORE_DATE_FORMAT);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        return f;
    }

    static final class StoreLogXMLParser {
        private StoreLogXMLParser() {
        }

        static List parse(Reader reader) throws ParseException, JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build(reader);
            return StoreLogXMLParser.parseDOMTree(document);
        }

        static List parseDOMTree(Document document) throws ParseException {
            ArrayList modifications = new ArrayList();
            Element rootElement = document.getRootElement();
            List packageEntries = rootElement.getChildren("package");
            for (Element packageEntry : packageEntries) {
                List modificationsOfRevision = StoreLogXMLParser.parsePackageEntry(packageEntry);
                modifications.addAll(modificationsOfRevision);
            }
            return modifications;
        }

        static List parsePackageEntry(Element packageEntry) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            List blessings = packageEntry.getChildren("blessing");
            for (Element blessing : blessings) {
                Modification modification = new Modification("store");
                modification.modifiedTime = StoreLogXMLParser.convertDate(blessing.getAttributeValue("timestamp"));
                modification.userName = blessing.getAttributeValue("user");
                modification.comment = blessing.getText();
                modification.revision = packageEntry.getAttributeValue("version");
                Modification.ModifiedFile modfile = modification.createModifiedFile(packageEntry.getAttributeValue("name"), null);
                modfile.action = packageEntry.getAttributeValue("action");
                modfile.revision = modification.revision;
                modifications.add(modification);
            }
            return modifications;
        }

        static Date convertDate(String date) throws ParseException {
            return Store.getDateFormatter().parse(date);
        }
    }
}

