/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class SnapshotCM
implements SourceControl {
    private final SimpleDateFormat inDateFormatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    public static final String OUT_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private final SimpleDateFormat outDateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final MessageFormat EXECUTABLE = new MessageFormat("whist -RA -c{0} \"{1}\"");
    private static final String FILE_HEADER = "=============================================================";
    private static final String REVISION_HEADER = "----------------------------";
    private static final String CHANGE_DELETE = "Delete";
    private static final Logger LOG = Logger.getLogger(SnapshotCM.class);
    private SourceControlProperties properties = new SourceControlProperties();
    private List sourcePaths = new ArrayList();

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setSourcePaths(String sourcePaths) {
        StringTokenizer st = new StringTokenizer(sourcePaths, ";");
        while (st.hasMoreTokens()) {
            this.setSourcePath(st.nextToken());
        }
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePaths.add(new SourcePath(sourcePath));
    }

    public SourcePath createSourcePath() {
        SourcePath sourcePath = new SourcePath();
        this.sourcePaths.add(sourcePath);
        return sourcePath;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.sourcePaths.isEmpty(), "'sourcePaths' or 'sourcePath' attribute, or nested sourcepath element(s) is a required attribute for SnapshotCM.");
    }

    public List getModifications(Date lastBuild, Date now) {
        ArrayList modificationList = new ArrayList();
        String[] parameters = new String[2];
        parameters[0] = this.inDateFormatter.format(lastBuild);
        Iterator i = this.sourcePaths.iterator();
        while (i.hasNext()) {
            parameters[1] = ((SourcePath)i.next()).getPath();
            String command = EXECUTABLE.format(parameters);
            LOG.info((Object)("Running command: " + command));
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.getOutputStream().close();
                Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p));
                stderr.start();
                InputStream input = p.getInputStream();
                modificationList.addAll(this.parseStream(input));
                p.waitFor();
                stderr.join();
                IO.close(p);
            }
            catch (Exception e) {
                LOG.error((Object)"Error in executing the SnapshotCM command : ", (Throwable)e);
            }
        }
        this.properties.modificationFound();
        return modificationList;
    }

    List parseStream(InputStream input) throws IOException {
        List fileMods;
        String line;
        ArrayList modifications = new ArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.equals(FILE_HEADER)) {
                fileMods = this.parseEntry(sb.toString());
                modifications.addAll(fileMods);
                sb = new StringBuffer();
                continue;
            }
            sb.append(line);
            sb.append('\n');
        }
        fileMods = this.parseEntry(sb.toString());
        modifications.addAll(fileMods);
        return modifications;
    }

    private List parseEntry(String entry) {
        String nextToken;
        String fileName;
        String folderName;
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        StringTokenizer st = new StringTokenizer(entry, "\n");
        if (st.countTokens() < 13) {
            return modifications;
        }
        String line = st.nextToken();
        String entryname = line.substring(6);
        int sep = entryname.lastIndexOf("/");
        if (sep == -1) {
            sep = entryname.lastIndexOf("\\");
        }
        if (sep > -1) {
            folderName = entryname.substring(0, sep);
            fileName = entryname.substring(sep + 1);
        } else {
            folderName = "";
            fileName = entryname;
        }
        while (!(nextToken = st.nextToken()).equals(REVISION_HEADER)) {
        }
        Modification mod = new Modification("snapshotcm");
        mod.createModifiedFile(fileName, folderName);
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            if (line.equals(REVISION_HEADER) || !st.hasMoreTokens()) {
                if (!line.trim().equals("") && !line.equals(REVISION_HEADER)) {
                    mod.comment = mod.comment + line;
                }
                modifications.add(mod);
                mod = new Modification("snapshotcm");
                mod.createModifiedFile(fileName, folderName);
                continue;
            }
            if (line.startsWith("Revision: ")) {
                int nextSpaceDelimiterIndex = line.indexOf(" ", 10);
                int endIndex = nextSpaceDelimiterIndex > -1 ? nextSpaceDelimiterIndex : line.length();
                mod.revision = line.substring(10, endIndex);
                continue;
            }
            if (line.startsWith("Date: ")) {
                try {
                    mod.modifiedTime = this.outDateFormatter.parse(line.substring(6, line.indexOf("-") - 1));
                }
                catch (ParseException pe) {
                    LOG.warn((Object)("Unable to parse date " + line.substring(6, line.indexOf("-") - 1)));
                    mod.modifiedTime = new Date(0L);
                }
                continue;
            }
            if (line.startsWith("Author: ")) {
                mod.userName = line.substring(8).trim();
                if (mod.userName.indexOf(" ") <= -1) continue;
                mod.userName = mod.userName.substring(0, mod.userName.indexOf(" "));
                continue;
            }
            if (line.startsWith("Change: ")) {
                mod.type = line.substring(8).trim();
                if (!mod.type.equals(CHANGE_DELETE)) continue;
                this.properties.deletionFound();
                continue;
            }
            if (line.startsWith("Snapshot: ") || line.startsWith("Used in: ") || line.startsWith("         /") || line.trim().equals("")) continue;
            mod.comment = mod.comment + line;
        }
        return modifications;
    }

    public static class SourcePath {
        private String path;

        public SourcePath() {
        }

        public SourcePath(String path) {
            this.path = path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

