/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSCM
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(SSCM.class);
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    private final SSCMCLIStringParam strparamBranch = new SSCMCLIStringParam("branch", "-b", false);
    private final SSCMCLIStringParam strparamRepository = new SSCMCLIStringParam("repository", "-p", false);
    private final SSCMCLIStringParam strparamFile = new SSCMCLIStringParam("file", "", false);
    private final SSCMCLIStringParam strparamServerConnect = new SSCMCLIStringParam("serverconnect", "-z", false);
    private final SSCMCLIStringParam strparamServerLogin = new SSCMCLIStringParam("serverlogin", "-y", false);
    private final SSCMCLIBoolParam fparamSearchRegExp = new SSCMCLIBoolParam("searchregexp", "-x", false);
    private final SSCMCLIBoolParam fparamRecursive = new SSCMCLIBoolParam("recursive", "-r", false);
    private final SourceControlProperties properties = new SourceControlProperties();

    @Override
    public void validate() throws CruiseControlException {
    }

    public void setBranch(String str) {
        this.strparamBranch.setData(str);
    }

    public void setRepository(String str) {
        this.strparamRepository.setData(str);
    }

    public void setFile(String str) {
        this.strparamFile.setData(str);
    }

    public void setServerConnect(String str) {
        this.strparamServerConnect.setData(str);
    }

    public void setServerLogin(String str) {
        this.strparamServerLogin.setData(str);
    }

    public void setSearchRegExp(String str) {
        if (str.equals("1")) {
            this.fparamSearchRegExp.setData(null);
        }
    }

    public void setRecursive(String str) {
        if (str.equals("1")) {
            this.fparamRecursive.setData(null);
        }
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        ArrayList<SSCMCLIParam> paramList = new ArrayList<SSCMCLIParam>();
        if (!this.strparamFile.isSet()) {
            this.strparamFile.setData("/");
        }
        paramList.add(this.strparamFile);
        paramList.add(this.strparamBranch);
        paramList.add(this.strparamRepository);
        paramList.add(this.fparamRecursive);
        paramList.add(this.fparamSearchRegExp);
        paramList.add(this.strparamServerLogin);
        paramList.add(this.strparamServerConnect);
        List<Modification> listMods = this.executeCLICommand(paramList, this.buildDateTimeRangeCLIParam(lastBuild, now));
        if (listMods == null) {
            listMods = Collections.emptyList();
        }
        if (!listMods.isEmpty()) {
            this.properties.modificationFound();
        }
        return listMods;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    protected List<Modification> executeCLICommand(List<SSCMCLIParam> paramList, String strDTRangeParam) {
        List<Modification> listMods = null;
        Commandline command = new Commandline();
        command.setExecutable("sscm");
        command.createArgument().setValue("cc");
        boolean fAllRequirementsMet = true;
        for (int i = 0; i < paramList.size() && fAllRequirementsMet; ++i) {
            SSCMCLIParam param = paramList.get(i);
            if (param == null) continue;
            if (param.checkRequired()) {
                String str = param.getFormatted();
                if (str == null) continue;
                command.createArgument().setValue(str);
                LOG.debug((Object)("Added cmd part: " + str));
                continue;
            }
            fAllRequirementsMet = false;
            LOG.error((Object)("Required parameter '" + param.getParamName() + "' is missing!"));
        }
        if (fAllRequirementsMet) {
            command.createArgument().setValue(strDTRangeParam);
            LOG.debug((Object)("Added DTRangeParam: " + strDTRangeParam));
            try {
                Process process = command.execute();
                Thread stderr = new Thread(new StreamPumper(process.getErrorStream(), StreamLogger.getInfoLogger(LOG)));
                stderr.start();
                InputStream input = process.getInputStream();
                listMods = this.parseCLIOutput(input);
                process.waitFor();
                stderr.join();
                IO.close(process);
            }
            catch (IOException e) {
                LOG.error((Object)"Problem trying to execute command line process", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Problem trying to execute command line process", (Throwable)e);
            }
        }
        return listMods;
    }

    protected List<Modification> parseCLIOutput(InputStream input) throws IOException {
        ArrayList<Modification> listMods = new ArrayList<Modification>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = reader.readLine();
        LOG.debug((Object)("\nSSCM mod line: " + line + "\n"));
        if (!"total-0".equals(line)) {
            while ((line = reader.readLine()) != null) {
                Modification mod = this.parseOutputLine(line);
                if (mod == null) continue;
                listMods.add(mod);
            }
        }
        return listMods;
    }

    protected Modification parseOutputLine(String str) {
        LOG.debug((Object)("Output-" + str + "-\n"));
        if (str == null || str.length() == 0) {
            return null;
        }
        Modification mod = new Modification("sscm");
        Modification.ModifiedFile modfile = mod.createModifiedFile(null, null);
        boolean fValid = false;
        String strToken = "><";
        int iLeft = 1;
        int iRight = str.indexOf("><", iLeft);
        if (iRight > iLeft) {
            modfile.folderName = str.substring(iLeft, iRight);
            iLeft = iRight + "><".length();
            if ((iRight = str.indexOf("><", iLeft)) > iLeft) {
                modfile.fileName = str.substring(iLeft, iRight);
                iLeft = iRight + "><".length();
                if ((iRight = str.indexOf("><", iLeft)) > iLeft) {
                    mod.revision = str.substring(iLeft, iRight);
                    iLeft = iRight + "><".length();
                    if ((iRight = str.indexOf("><", iLeft)) > iLeft) {
                        modfile.action = str.substring(iLeft, iRight);
                        iLeft = iRight + "><".length();
                        if ((iRight = str.indexOf("><", iLeft)) > iLeft) {
                            mod.modifiedTime = this.buildDateTimeFromCLIOutput(str.substring(iLeft, iRight));
                            iLeft = iRight + "><".length();
                            if ((iRight = str.indexOf("><", iLeft)) >= iLeft) {
                                mod.comment = str.substring(iLeft, iRight);
                                iLeft = iRight + "><".length();
                                if ((iRight = str.indexOf("><", iLeft)) > iLeft) {
                                    mod.userName = str.substring(iLeft, iRight);
                                    iLeft = iRight + "><".length();
                                    if ((iRight = str.indexOf(">", iLeft)) >= iLeft) {
                                        mod.emailAddress = str.substring(iLeft, iRight);
                                        fValid = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!fValid) {
            mod = null;
            LOG.debug((Object)"Invalid output; skipping this entry");
        }
        return mod;
    }

    protected String buildDateTimeRangeCLIParam(Date lastBuild, Date now) {
        String strLast = this.formatter.format(lastBuild);
        String strNow = this.formatter.format(now);
        return "-d" + strLast + ":" + strNow;
    }

    protected Date buildDateTimeFromCLIOutput(String str) {
        Date dt;
        try {
            dt = this.formatter.parse(str);
        }
        catch (ParseException e) {
            dt = null;
            LOG.error((Object)"Unable to parse DateTime from Surround", (Throwable)e);
        }
        return dt;
    }

    public static class SSCMCLIStringParam
    extends SSCMCLIParam {
        private String strData;

        public SSCMCLIStringParam(String strParamNameIN, String strParamIN, boolean fIsRequiredIN) {
            super(strParamNameIN, strParamIN, fIsRequiredIN);
        }

        public void setData(Object obj) {
            this.strData = (String)obj;
            this.setSet(true);
        }

        public String getFormatted() {
            String str = null;
            if (this.isSet()) {
                str = this.getParam() + this.strData;
            }
            return str;
        }
    }

    public static class SSCMCLIBoolParam
    extends SSCMCLIParam {
        private boolean fData;

        public SSCMCLIBoolParam(String strParamNameIN, String strParamIN, boolean fIsRequiredIN) {
            super(strParamNameIN, strParamIN, fIsRequiredIN);
        }

        public void setData(Object obj) {
            this.fData = true;
            this.setSet(true);
        }

        public String getFormatted() {
            String str = null;
            if (this.isSet() && this.fData) {
                str = this.getParam();
            }
            return str;
        }
    }

    public static abstract class SSCMCLIParam {
        private final String strParamName;
        private final String strParam;
        private boolean fIsRequired;
        private boolean fIsSet;

        public SSCMCLIParam(String strParamNameIN, String strParamIN, boolean fIsRequiredIN) {
            this.strParamName = strParamNameIN;
            this.strParam = strParamIN;
            this.fIsRequired = fIsRequiredIN;
            this.fIsSet = false;
        }

        public String getParamName() {
            return this.strParamName;
        }

        public String getParam() {
            return this.strParam;
        }

        public void setRequired(boolean f) {
            this.fIsRequired = f;
        }

        public boolean isRequired() {
            return this.fIsRequired;
        }

        public boolean isSet() {
            return this.fIsSet;
        }

        public boolean checkRequired() {
            return !this.isRequired() || this.isSet();
        }

        public abstract String getFormatted();

        public abstract void setData(Object var1);

        protected void setSet(boolean f) {
            this.fIsSet = f;
        }
    }
}

