/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class PlasticSCM
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(PlasticSCM.class);
    private String wkspath;
    private String branch;
    private String repository;
    private SourceControlProperties properties = new SourceControlProperties();
    public static final String DATEFORMAT = "dd.MM.yyyy.HH.mm.ss";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy.HH.mm.ss");
    public static final String DELIMITER = "#@&@#";
    public static final String QUERYFORMAT = "#@&@#{item}#@&@#{owner}#@&@#{date}";

    public void setWkspath(String wkspath) {
        this.wkspath = wkspath;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.wkspath, "wkspath", this.getClass());
        ValidationHelper.assertIsSet((Object)this.branch, "branch", this.getClass());
        File workingDir = new File(this.wkspath);
        ValidationHelper.assertTrue(workingDir.exists(), "'wkspath' must be an existing directory. Was <" + this.wkspath + ">");
        ValidationHelper.assertTrue(workingDir.isDirectory(), "'wkspath' must be an existing directory, not a file. Was <" + this.wkspath + ">");
    }

    public List getModifications(Date lastBuild, Date now) {
        List modifications;
        try {
            Commandline commandLine = this.buildFindCommand(lastBuild, now);
            Process p = commandLine.execute();
            InputStream input = p.getInputStream();
            modifications = this.parseStream(input);
            p.waitFor();
            IO.close(p);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in executing the PlasticSCM command : ", (Throwable)e);
            return new ArrayList();
        }
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
        }
        return modifications;
    }

    protected Commandline buildFindCommand(Date lastBuild, Date now) throws CruiseControlException {
        Commandline commandLine = new Commandline();
        commandLine.setWorkingDirectory(this.wkspath);
        commandLine.setExecutable("cm");
        commandLine.createArgument("find");
        commandLine.createArgument("revision");
        commandLine.createArgument("where");
        commandLine.createArguments("branch", "=");
        commandLine.createArgument("'" + this.branch + "'");
        commandLine.createArguments("and", "revno");
        commandLine.createArguments("!=", "'CO'");
        commandLine.createArguments("and", "date");
        commandLine.createArguments("between", "'" + this.dateFormat.format(lastBuild) + "'");
        commandLine.createArguments("and", "'" + this.dateFormat.format(now) + "'");
        if (this.repository != null) {
            commandLine.createArguments("on", "repository");
            commandLine.createArgument("'" + this.repository + "'");
        }
        commandLine.createArgument("--dateformat=\"dd.MM.yyyy.HH.mm.ss\"");
        commandLine.createArgument("--format=\"#@&@#{item}#@&@#{owner}#@&@#{date}\"");
        return commandLine;
    }

    protected List parseStream(InputStream input) throws IOException, ParseException {
        String line;
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        HashSet<File> modifiedFiles = new HashSet<File>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            String[] fields;
            File file;
            if (!line.startsWith(DELIMITER) || line.equals("") || line.startsWith("Total:") || !(file = new File((fields = line.split(DELIMITER))[1])).isFile() || modifiedFiles.contains(file)) continue;
            Modification mod = new Modification("plasticscm");
            mod.createModifiedFile(file.getName(), file.getParent());
            mod.userName = fields[2];
            mod.modifiedTime = this.dateFormat.parse(fields[3]);
            modifications.add(mod);
            modifiedFiles.add(file);
        }
        return modifications;
    }
}

