/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.CommandExecutor;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class PVCS
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(PVCS.class);
    private static final String PCLI = "pcli";
    private String archiveFileSuffix = "-arc";
    private SimpleDateFormat inDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
    private String loginId;
    private SimpleDateFormat outDateFormat = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
    private final SourceControlProperties properties = new SourceControlProperties();
    private String pvcsbin;
    private String pvcsProject;
    private String pvcsPromotionGroup;
    private String pvcsSubProject;
    private String pvcsVersionLabel;

    Commandline buildExecCommand(String lastBuild, String now) {
        Commandline command = new Commandline();
        command.setExecutable(this.getExecutable(PCLI));
        command.createArgument("run");
        command.createArgument("-ns");
        command.createArgument("-q");
        command.createArgument("vlog");
        if (this.loginId != null && !this.loginId.trim().equals("")) {
            command.createArgument("-id" + this.loginId);
        }
        command.createArgument("-ds" + lastBuild);
        command.createArgument("-de" + now);
        command.createArgument("-pr" + this.pvcsProject);
        if (this.pvcsVersionLabel != null && !this.pvcsVersionLabel.equals("")) {
            command.createArgument("-v" + this.pvcsVersionLabel);
        }
        if (this.pvcsPromotionGroup != null && !this.pvcsPromotionGroup.equals("")) {
            command.createArgument("-g" + this.pvcsPromotionGroup);
        }
        command.createArgument("-z");
        command.createArgument(this.pvcsSubProject);
        return command;
    }

    protected void executeCommandline(Commandline command, PvcsStreamConsumer consumer) throws CruiseControlException {
        LOG.info((Object)("Running command: " + command));
        CommandExecutor executor = new CommandExecutor(command, LOG);
        executor.setOutputConsumer(consumer);
        executor.executeAndWait();
        LOG.debug((Object)("Output: \n" + consumer.getOutput()));
    }

    protected String getExecutable(String exe) {
        StringBuffer correctedExe = new StringBuffer();
        if (this.getPvcsbin() != null) {
            if (this.getPvcsbin().endsWith(File.separator)) {
                correctedExe.append(this.getPvcsbin());
            } else {
                correctedExe.append(this.getPvcsbin()).append(File.separator);
            }
        }
        return correctedExe.append(exe).toString();
    }

    public String getLoginid() {
        return this.loginId;
    }

    public List getModifications(Date lastBuild, Date now) {
        PvcsStreamConsumer consumer = new PvcsStreamConsumer(lastBuild, this.outDateFormat, this.pvcsProject, this.archiveFileSuffix);
        List modificationList = this.getModifications(lastBuild, now, consumer);
        return modificationList;
    }

    protected List getModifications(Date lastBuild, Date now, PvcsStreamConsumer consumer) {
        try {
            String lastBuildDate = this.inDateFormat.format(lastBuild);
            String nowDate = this.inDateFormat.format(now);
            Commandline command = this.buildExecCommand(lastBuildDate, nowDate);
            this.executeCommandline(command, consumer);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in executing the PVCS command : ", (Throwable)e);
        }
        List modificationList = consumer.getModificationList();
        if (!modificationList.isEmpty()) {
            this.properties.modificationFound();
        }
        StringBuffer msg = new StringBuffer("" + modificationList.size());
        if (1 == modificationList.size()) {
            msg.append(" modification has been detected");
        } else {
            msg.append(" modifications have been detected");
        }
        msg.append(" for ").append(this.pvcsSubProject).append(".");
        LOG.info((Object)msg.toString());
        return modificationList;
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public String getPvcsbin() {
        return this.pvcsbin;
    }

    public void setArchiveFileSuffix(String archiveSuffix) {
        this.archiveFileSuffix = archiveSuffix;
    }

    public void setInDateFormat(String inDateFormat) {
        this.inDateFormat = new SimpleDateFormat(inDateFormat);
    }

    public void setLoginid(String loginId) {
        this.loginId = loginId;
    }

    public void setOutDateFormat(String outDateFormat) {
        this.outDateFormat = new SimpleDateFormat(outDateFormat);
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    public void setPvcsbin(String bin) {
        this.pvcsbin = bin;
    }

    public void setPvcsproject(String project) {
        this.pvcsProject = project;
    }

    public void setPvcspromotiongroup(String promotiongroup) {
        this.pvcsPromotionGroup = promotiongroup;
    }

    public void setPvcssubproject(String subproject) {
        this.pvcsSubProject = subproject;
    }

    public void setPvcsversionlabel(String versionlabel) {
        this.pvcsVersionLabel = versionlabel;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.pvcsProject, "pvcsproject", this.getClass());
        ValidationHelper.assertIsSet((Object)this.pvcsSubProject, "pvcssubproject", this.getClass());
    }

    public static class PvcsStreamConsumer
    implements StreamConsumer {
        private static final Logger LOGGER = Logger.getLogger(PVCS.class);
        private final String archiveFileSuffix;
        private boolean firstModifiedTime = true;
        private boolean firstRev = true;
        private boolean firstUserName = true;
        private final Date lastBuild;
        private final String ls = System.getProperty("line.separator");
        private Modification modification;
        private final List modificationList = new ArrayList();
        private boolean nextLineIsComment = false;
        private final DateFormat outDateFormat;
        private final DateFormat outDateFormatSub = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        private final String proj;
        private final StringBuffer string = new StringBuffer();
        private boolean waitingForNextValidStart = false;

        public PvcsStreamConsumer(Date lastBuild, DateFormat format, String proj, String suffix) {
            this.proj = proj;
            this.lastBuild = lastBuild;
            this.archiveFileSuffix = suffix;
            this.outDateFormat = format;
        }

        public void consumeLine(String line) {
            block30: {
                this.string.append(line + this.ls);
                if (line.startsWith("Archive:")) {
                    String fileName;
                    this.initializeModification();
                    int startIndex = line.indexOf(this.proj) + this.proj.length();
                    int endIndex = line.indexOf(this.archiveFileSuffix);
                    if (endIndex == -1) {
                        endIndex = line.length();
                    }
                    if ((fileName = line.substring(startIndex, endIndex)).startsWith("/") || fileName.startsWith("\\")) {
                        fileName = fileName.substring(1);
                    }
                    if (fileName.startsWith("archives")) {
                        fileName = fileName.substring("archives".length());
                    }
                    this.modification.createModifiedFile(fileName, null);
                } else if (!this.waitingForNextValidStart) {
                    if (line.startsWith("Archive created:")) {
                        try {
                            Date createTime;
                            String createdDate = line.substring(18);
                            try {
                                createTime = this.outDateFormat.parse(createdDate);
                            }
                            catch (ParseException e) {
                                createTime = this.outDateFormatSub.parse(createdDate);
                            }
                            Modification.ModifiedFile file = this.modification.files.get(0);
                            if (createTime.after(this.lastBuild)) {
                                file.action = "added";
                                break block30;
                            }
                            file.action = "modified";
                        }
                        catch (ParseException e) {
                            LOGGER.error((Object)("Error parsing create date: " + e.getMessage()), (Throwable)e);
                        }
                    } else if (line.startsWith("Rev") && !line.startsWith("Rev count")) {
                        if (this.firstRev) {
                            String revision;
                            this.firstRev = false;
                            this.modification.revision = revision = line.substring(4);
                            Modification.ModifiedFile file = this.modification.files.get(0);
                            file.revision = revision;
                        }
                    } else if (line.startsWith("Last modified:")) {
                        if (this.firstModifiedTime) {
                            this.firstModifiedTime = false;
                            String lastMod = null;
                            try {
                                lastMod = line.substring(16);
                                this.modification.modifiedTime = this.outDateFormat.parse(lastMod);
                            }
                            catch (ParseException e) {
                                try {
                                    this.modification.modifiedTime = this.outDateFormatSub.parse(lastMod);
                                }
                                catch (ParseException pe) {
                                    this.modification.modifiedTime = null;
                                    LOGGER.error((Object)"Error parsing modification time : ", (Throwable)e);
                                }
                            }
                        }
                    } else if (this.nextLineIsComment) {
                        boolean isEndOfCommentsLine;
                        boolean isDashesLine = line.startsWith("----------");
                        boolean isEqualsLine = line.startsWith("==========");
                        boolean bl = isEndOfCommentsLine = isDashesLine || isEqualsLine;
                        if (this.modification.comment == null || this.modification.comment.length() == 0) {
                            this.modification.comment = line;
                        } else if (!isEndOfCommentsLine) {
                            this.modification.comment = this.modification.comment + System.getProperty("line.separator") + line;
                        } else {
                            this.modificationList.add(this.modification);
                            this.waitingForNextValidStart = true;
                        }
                    } else if (line.startsWith("Author id:") && this.firstUserName) {
                        String sub = line.substring(11);
                        StringTokenizer st = new StringTokenizer(sub, " ");
                        this.modification.userName = st.nextToken().trim();
                        this.firstUserName = false;
                        this.nextLineIsComment = true;
                    }
                }
            }
        }

        public List getModificationList() {
            return this.modificationList;
        }

        public String getOutput() {
            return this.string.toString();
        }

        private void initializeModification() {
            this.modification = new Modification("pvcs");
            this.firstModifiedTime = true;
            this.firstUserName = true;
            this.nextLineIsComment = false;
            this.waitingForNextValidStart = false;
        }
    }
}

