/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.CommandExecutor;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.DiscardConsumer;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class P4
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(P4.class);
    private String p4Port;
    private String p4Client;
    private String p4User;
    private String p4View;
    private String p4Passwd;
    private boolean correctForServerTime = true;
    private boolean useP4Email = true;
    private final SimpleDateFormat p4RevisionDateFormatter = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss");
    private final SourceControlProperties properties = new SourceControlProperties();
    private static final String SERVER_DATE = "Server date: ";
    private static final String P4_SERVER_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public void setPort(String p4Port) {
        this.p4Port = p4Port;
    }

    public void setClient(String p4Client) {
        this.p4Client = p4Client;
    }

    public void setUser(String p4User) {
        this.p4User = p4User;
    }

    public void setView(String p4View) {
        this.p4View = p4View;
    }

    public void setPasswd(String p4Passwd) {
        this.p4Passwd = p4Passwd;
    }

    public void setCorrectForServerTime(boolean flag) {
        this.correctForServerTime = flag;
    }

    public void setUseP4Email(boolean flag) {
        this.useP4Email = flag;
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.p4Port, "port", this.getClass());
        ValidationHelper.assertIsSet((Object)this.p4Client, "client", this.getClass());
        ValidationHelper.assertIsSet((Object)this.p4User, "user", this.getClass());
        ValidationHelper.assertIsSet((Object)this.p4View, "view", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4Passwd, "passwd", this.getClass());
    }

    public List getModifications(Date lastBuild, Date now) {
        List mods = new ArrayList();
        try {
            String[] changelistNumbers = this.collectChangelistSinceLastBuild(lastBuild, now);
            if (changelistNumbers.length == 0) {
                return mods;
            }
            mods = this.describeAllChangelistsAndBuildOutput(changelistNumbers);
        }
        catch (Exception e) {
            LOG.error((Object)"Log command failed to execute succesfully", (Throwable)e);
        }
        if (!mods.isEmpty()) {
            this.properties.modificationFound();
        }
        return mods;
    }

    private List describeAllChangelistsAndBuildOutput(String[] changelistNumbers) throws Exception {
        Commandline command = this.buildDescribeCommand(changelistNumbers);
        LOG.debug((Object)command.toString());
        Process p = command.execute();
        Thread error = this.logErrorStream(p.getErrorStream());
        InputStream p4Stream = p.getInputStream();
        List mods = this.parseChangeDescriptions(p4Stream);
        this.getRidOfLeftoverData(p4Stream);
        if (mods.size() > 0 && this.useP4Email) {
            this.getEmailAddresses(mods);
        }
        p.waitFor();
        error.join();
        IO.close(p);
        return mods;
    }

    private void getEmailAddresses(List mods) throws IOException, InterruptedException {
        Iterator iter = mods.iterator();
        HashMap<String, String> users = new HashMap<String, String>();
        while (iter.hasNext()) {
            P4Modification change = (P4Modification)iter.next();
            if (change.userName == null || change.userName.length() <= 0) continue;
            change.emailAddress = (String)users.get(change.userName);
            if (change.emailAddress != null) continue;
            change.emailAddress = this.getUserEmailAddress(change.userName);
            users.put(change.userName, change.emailAddress);
        }
    }

    private String getUserEmailAddress(String username) throws IOException, InterruptedException {
        String line;
        String emailaddr = null;
        Commandline command = this.buildUserCommand(username);
        LOG.debug((Object)command.toString());
        Process p = command.execute();
        this.logErrorStream(p.getErrorStream());
        InputStream p4Stream = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p4Stream));
        while ((line = this.readToNotPast(reader, "info: Email:", "I really don't care")) != null) {
            StringTokenizer st = new StringTokenizer(line);
            try {
                st.nextToken();
                st.nextToken();
                emailaddr = st.nextToken();
            }
            catch (NoSuchElementException ex) {}
        }
        this.getRidOfLeftoverData(p4Stream);
        p.waitFor();
        IO.close(p);
        return emailaddr;
    }

    private String[] collectChangelistSinceLastBuild(Date lastBuild, Date now) throws Exception {
        Commandline command = this.buildChangesCommand(lastBuild, now, Util.isWindows());
        LOG.debug((Object)command.toString());
        Process p = command.execute();
        Thread error = this.logErrorStream(p.getErrorStream());
        InputStream p4Stream = p.getInputStream();
        String[] changelistNumbers = this.parseChangelistNumbers(p4Stream);
        p.waitFor();
        error.join();
        IO.close(p);
        return changelistNumbers;
    }

    private void getRidOfLeftoverData(InputStream stream) {
        new StreamPumper(stream, new DiscardConsumer()).run();
    }

    protected String[] parseChangelistNumbers(InputStream is) throws IOException {
        String line;
        ArrayList<String> changelists = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("error:")) {
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("exit: 1")) {
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("exit: 0")) break;
            if (!line.startsWith("info:")) continue;
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            st.nextToken();
            changelists.add(st.nextToken());
        }
        if (line == null) {
            throw new IOException("Error reading P4 stream: Unexpected EOF reached");
        }
        String[] changelistNumbers = new String[]{};
        return changelists.toArray(changelistNumbers);
    }

    protected List parseChangeDescriptions(InputStream is) throws Exception {
        String line;
        int serverOffset = 0;
        if (this.correctForServerTime) {
            serverOffset = (int)this.calculateServerTimeOffset();
        }
        ArrayList<P4Modification> changelists = new ArrayList<P4Modification>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = this.readToNotPast(reader, "text: Change", "exit:")) != null) {
            P4Modification changelist = new P4Modification();
            if (line.startsWith("error:")) {
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("exit: 1")) {
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("exit: 0")) {
                return changelists;
            }
            if (line.startsWith("text: Change")) {
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                st.nextToken();
                changelist.revision = st.nextToken();
                st.nextToken();
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "@");
                changelist.userName = st2.nextToken();
                changelist.client = st2.nextToken();
                st.nextToken();
                String date = st.nextToken() + ":" + st.nextToken();
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.p4RevisionDateFormatter.parse(date));
                    cal.add(14, -serverOffset);
                    changelist.modifiedTime = cal.getTime();
                }
                catch (ParseException xcp) {
                    changelist.modifiedTime = new Date();
                }
            }
            reader.readLine();
            StringBuffer descriptionBuffer = new StringBuffer();
            String previousLine = null;
            line = reader.readLine();
            while (line != null && line.startsWith("text:") && !line.startsWith("text: Affected files ...")) {
                if (previousLine != null) {
                    if (descriptionBuffer.length() > 0) {
                        descriptionBuffer.append('\n');
                    }
                    descriptionBuffer.append(previousLine);
                }
                try {
                    previousLine = line.substring(5).trim();
                }
                catch (Exception e) {
                    LOG.error((Object)("Error parsing Perforce description, line that caused problem was: [" + line + "]"));
                }
                line = reader.readLine();
            }
            changelist.comment = descriptionBuffer.toString();
            if (line != null) {
                reader.readLine();
                line = this.readToNotPast(reader, "info1:", "text:");
                while (line != null && line.startsWith("info1:")) {
                    String fileName = line.substring(7, line.lastIndexOf("#"));
                    Modification.ModifiedFile affectedFile = changelist.createModifiedFile(fileName, null);
                    affectedFile.action = line.substring(line.lastIndexOf(" ") + 1);
                    affectedFile.revision = line.substring(line.lastIndexOf("#") + 1, line.lastIndexOf(" "));
                    line = this.readToNotPast(reader, "info1:", "text:");
                }
            }
            changelists.add(changelist);
        }
        return changelists;
    }

    private Thread logErrorStream(InputStream is) {
        Thread errorThread = new Thread(StreamLogger.getWarnPumper(LOG, is));
        errorThread.start();
        return errorThread;
    }

    public Commandline buildChangesCommand(Date lastBuildTime, Date now, boolean isWindows) throws CruiseControlException {
        if (this.correctForServerTime) {
            int offset = (int)this.calculateServerTimeOffset();
            Calendar cal = Calendar.getInstance();
            cal.setTime(lastBuildTime);
            cal.add(14, offset);
            lastBuildTime = cal.getTime();
            cal.setTime(now);
            cal.add(14, offset);
            now = cal.getTime();
        } else {
            LOG.debug((Object)"No server time offset determined.");
        }
        Commandline commandLine = this.buildBaseP4Command();
        commandLine.createArgument("changes");
        commandLine.createArguments("-s", "submitted");
        commandLine.createArgument(this.p4View + "@" + this.p4RevisionDateFormatter.format(lastBuildTime) + ",@" + this.p4RevisionDateFormatter.format(now));
        return commandLine;
    }

    public Commandline buildDescribeCommand(String[] changelistNumbers) {
        Commandline commandLine = this.buildBaseP4Command();
        commandLine.createArgument("describe");
        commandLine.createArgument("-s");
        for (int i = 0; i < changelistNumbers.length; ++i) {
            commandLine.createArgument(changelistNumbers[i]);
        }
        return commandLine;
    }

    public Commandline buildUserCommand(String username) {
        Commandline commandLine = this.buildBaseP4Command();
        commandLine.createArgument("user");
        commandLine.createArguments("-o", username);
        return commandLine;
    }

    protected long calculateServerTimeOffset() throws CruiseControlException {
        ServerInfoConsumer serverInfo = new ServerInfoConsumer();
        CommandExecutor executor = new CommandExecutor(this.buildInfoCommand());
        executor.logErrorStreamTo(LOG);
        executor.setOutputConsumer(serverInfo);
        executor.executeAndWait();
        return serverInfo.getOffset();
    }

    Commandline buildInfoCommand() {
        Commandline command = this.buildBaseP4Command(false);
        command.createArgument("info");
        return command;
    }

    private Commandline buildBaseP4Command() {
        boolean prependField = true;
        return this.buildBaseP4Command(prependField);
    }

    private Commandline buildBaseP4Command(boolean prependField) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("p4");
        if (prependField) {
            commandLine.createArgument("-s");
        }
        if (this.p4Client != null) {
            commandLine.createArguments("-c", this.p4Client);
        }
        if (this.p4Port != null) {
            commandLine.createArguments("-p", this.p4Port);
        }
        if (this.p4User != null) {
            commandLine.createArguments("-u", this.p4User);
        }
        if (this.p4Passwd != null) {
            commandLine.createArguments("-P", this.p4Passwd);
        }
        return commandLine;
    }

    private String readToNotPast(BufferedReader reader, String beginsWith, String notPast) throws IOException {
        String nextLine = reader.readLine();
        while (nextLine != null && !nextLine.startsWith(beginsWith) && !nextLine.startsWith(notPast)) {
            nextLine = reader.readLine();
        }
        return nextLine;
    }

    static String getQuoteChar(boolean isWindows) {
        return isWindows ? "\"" : "'";
    }

    protected static class ServerInfoConsumer
    implements StreamConsumer {
        private boolean found;
        private long offset;
        private final SimpleDateFormat p4ServerDateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        private Date ccServerTime = new Date();

        protected ServerInfoConsumer() {
        }

        public void consumeLine(String line) {
            if (this.found) {
                return;
            }
            if (line.startsWith(P4.SERVER_DATE)) {
                try {
                    String dateString = line.substring(P4.SERVER_DATE.length(), P4.SERVER_DATE.length() + P4.P4_SERVER_DATE_FORMAT.length());
                    Date p4ServerTime = this.p4ServerDateFormatter.parse(dateString);
                    this.offset = p4ServerTime.getTime() - this.ccServerTime.getTime();
                    this.found = true;
                }
                catch (ParseException pe) {
                    LOG.error((Object)("Unable to parse p4 server time from line '" + line + "'.  " + pe.getMessage() + "; Proceeding without time offset."));
                }
            }
        }

        public long getOffset() {
            LOG.info((Object)("Perforce server time offset: " + this.offset + " ms"));
            return this.offset;
        }
    }

    private static class P4Modification
    extends Modification {
        public String client;

        public int compareTo(Object o) {
            P4Modification modification = (P4Modification)o;
            return this.getChangelistNumber() - modification.getChangelistNumber();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof P4Modification)) {
                return false;
            }
            P4Modification modification = (P4Modification)o;
            return this.getChangelistNumber() == modification.getChangelistNumber();
        }

        public int hashCode() {
            return this.getChangelistNumber();
        }

        private int getChangelistNumber() {
            return Integer.parseInt(this.revision);
        }

        P4Modification() {
            super("p4");
        }

        public Element toElement() {
            Element element = super.toElement();
            LOG.debug((Object)("client = " + this.client));
            Element clientElement = new Element("client");
            clientElement.addContent(this.client);
            element.addContent((Content)clientElement);
            return element;
        }
    }
}

