/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class MavenSnapshotDependency
implements SourceControl {
    private SourceControlProperties properties = new SourceControlProperties();
    private List modifications;
    private File projectFile;
    private File propertiesFile;
    private File localRepository = new File(System.getProperty("user.home") + "/.maven/repository/");
    private String user;
    private static final Logger LOG = Logger.getLogger(MavenSnapshotDependency.class);

    public void setProjectFile(String s) {
        this.projectFile = new File(s);
    }

    public void setPropertiesFile(String s) {
        this.propertiesFile = new File(s);
    }

    public void setLocalRepository(String s) {
        this.localRepository = new File(s);
    }

    public void setUser(String s) {
        this.user = s;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.projectFile, "projectFile", this.getClass());
        ValidationHelper.assertTrue(this.projectFile.exists(), "Project file '" + this.projectFile.getAbsolutePath() + "' does not exist.");
        ValidationHelper.assertFalse(this.projectFile.isDirectory(), "The directory '" + this.projectFile.getAbsolutePath() + "' cannot be used as the projectFile for MavenSnapshotDependency.");
        ValidationHelper.assertTrue(this.localRepository.exists(), "Local Maven repository '" + this.localRepository.getAbsolutePath() + "' does not exist.");
        ValidationHelper.assertTrue(this.localRepository.isDirectory(), "Local Maven repository '" + this.localRepository.getAbsolutePath() + "' must be a directory.");
    }

    public List getModifications(Date lastBuild, Date now) {
        this.modifications = new ArrayList();
        this.checkProjectDependencies(this.projectFile, lastBuild.getTime());
        return this.modifications;
    }

    private void addRevision(File dependency) {
        Modification mod = new Modification("maven");
        Modification.ModifiedFile modfile = mod.createModifiedFile(dependency.getName(), dependency.getParent());
        modfile.action = "change";
        mod.userName = this.user;
        mod.modifiedTime = new Date(dependency.lastModified());
        mod.comment = "Maven project dependency: timestamp change detected.";
        this.modifications.add(mod);
        this.properties.modificationFound();
    }

    private void checkProjectDependencies(File projectFile, long lastBuild) {
        List filenames = this.getSnapshotFilenames(projectFile);
        for (String filename : filenames) {
            File dependency = new File(filename);
            this.checkFile(dependency, lastBuild);
        }
    }

    String replaceVariables(Properties p, String value) {
        int j;
        if (value == null || p == null) {
            return value;
        }
        int i = value.indexOf("${");
        if (i == -1) {
            return value;
        }
        int pos = 0;
        while (i != -1 && (j = value.indexOf("}", i)) != -1) {
            String key = value.substring(i + 2, j);
            if (p.containsKey(key)) {
                value = value.substring(0, i) + p.getProperty(key) + value.substring(j + 1);
                pos = i + 1;
            } else if (System.getProperty(key) != null) {
                value = value.substring(0, i) + System.getProperty(key) + value.substring(j + 1);
                pos = i + 1;
            } else {
                pos = j + 1;
            }
            i = value.indexOf("${", pos);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getSnapshotFilenames(File mavenFile) {
        Element mavenElement;
        LOG.info((Object)("Getting a list of dependencies for " + mavenFile));
        ArrayList<String> filenames = new ArrayList<String>();
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        try {
            mavenElement = builder.build(mavenFile).getRootElement();
        }
        catch (JDOMException e) {
            LOG.error((Object)("failed to load project file [" + (mavenFile != null ? mavenFile.getAbsolutePath() : "") + "]"), (Throwable)e);
            return filenames;
        }
        catch (IOException e) {
            LOG.error((Object)("failed to load project file [" + (mavenFile != null ? mavenFile.getAbsolutePath() : "") + "]"), (Throwable)e);
            return filenames;
        }
        Properties projectProperties = new Properties();
        if (this.propertiesFile == null) {
            this.propertiesFile = new File(mavenFile.getParent() + "/build.properties");
        }
        if (this.propertiesFile.exists()) {
            BufferedInputStream in = null;
            try {
                FileInputStream fin = new FileInputStream(this.propertiesFile);
                in = new BufferedInputStream(fin);
                projectProperties.load(in);
            }
            catch (IOException ex) {
                try {
                    LOG.error((Object)("failed to load project properties file [" + this.propertiesFile.getAbsolutePath() + "]"), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IO.close(in);
                    throw throwable;
                }
                IO.close(in);
            }
            IO.close(in);
        }
        projectProperties.put("basedir", mavenFile.getParent());
        Namespace ns = mavenElement.getNamespace();
        Element depsRoot = mavenElement.getChild("dependencies", ns);
        if (depsRoot == null) {
            LOG.warn((Object)"No dependencies detected.");
            return filenames;
        }
        List dependencies = depsRoot.getChildren();
        for (Element dependency : dependencies) {
            String versionText = dependency.getChildText("version", ns);
            if (versionText == null || !versionText.endsWith("SNAPSHOT")) continue;
            String groupId = dependency.getChildText("groupId", ns);
            String artifactId = dependency.getChildText("artifactId", ns);
            String id = dependency.getChildText("id", ns);
            String type = dependency.getChildText("type", ns);
            artifactId = this.replaceVariables(projectProperties, artifactId);
            groupId = this.replaceVariables(projectProperties, groupId);
            id = this.replaceVariables(projectProperties, id);
            versionText = this.replaceVariables(projectProperties, versionText);
            if (type == null) {
                type = "jar";
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append(this.localRepository.getAbsolutePath());
            fileName.append('/');
            if (groupId != null) {
                fileName.append(groupId);
            } else {
                fileName.append(id);
            }
            fileName.append('/');
            if ("ejb-client".equals(type)) {
                fileName.append("ejb");
            } else {
                fileName.append(type);
            }
            fileName.append('s');
            fileName.append('/');
            if (artifactId != null) {
                fileName.append(artifactId);
            } else {
                fileName.append(id);
            }
            fileName.append('-');
            fileName.append(versionText);
            if ("ejb-client".equals(type)) {
                fileName.append("-client");
            }
            fileName.append('.');
            if ("uberjar".equals(type) || "ejb".equals(type) || "plugin".equals(type) || "ejb-client".equals(type)) {
                fileName.append("jar");
            } else {
                fileName.append(type);
            }
            File file = new File(fileName.toString());
            LOG.info((Object)("Snapshot detected: " + fileName));
            filenames.add(file.getAbsolutePath());
        }
        return filenames;
    }

    private void checkFile(File file, long lastBuild) {
        if (!file.isDirectory() && file.lastModified() > lastBuild) {
            this.addRevision(file);
        }
    }
}

