/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.Processes;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class MKS
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(MKS.class);
    private SourceControlProperties properties = new SourceControlProperties();
    private String project;
    private File localWorkingDir;
    private boolean doNothing;
    private List listOfModifications = new ArrayList();
    private Date lastBuild = new Date();

    public void setProject(String project) {
        this.project = project;
    }

    public void setLocalWorkingDir(String local) {
        this.localWorkingDir = new File(local);
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setDoNothing(String doNothing) {
        this.doNothing = Boolean.valueOf(doNothing);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.localWorkingDir, "localWorkingDir", this.getClass());
        ValidationHelper.assertIsSet((Object)this.project, "project", this.getClass());
    }

    public List getModifications(Date lastBuild, Date now) {
        if (this.doNothing) {
            this.properties.modificationFound();
            return this.listOfModifications;
        }
        if (this.lastBuild.compareTo(lastBuild) != 0) {
            this.listOfModifications.clear();
            this.lastBuild = lastBuild;
        }
        String projectFilePath = this.getProjectFilePath();
        Commandline cmdLine = this.createResyncCommandLine(projectFilePath);
        this.executeResyncAndParseModifications(cmdLine, this.listOfModifications);
        return this.listOfModifications;
    }

    void executeResyncAndParseModifications(Commandline cmdLine, List modifications) {
        try {
            ModificationsConsumer stderr = new ModificationsConsumer(modifications);
            StreamConsumer stdout = StreamLogger.getWarnLogger(LOG);
            Processes.waitFor(cmdLine.execute(), stdout, stderr);
        }
        catch (Exception ex) {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        LOG.info((Object)"resync finished");
    }

    Commandline createResyncCommandLine(String projectFilePath) {
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable("si");
        cmdLine.createArgument("resync");
        cmdLine.createArgument("-f");
        cmdLine.createArgument("-R");
        cmdLine.createArgument("-S");
        cmdLine.createArgument(projectFilePath);
        try {
            cmdLine.setWorkingDir(this.localWorkingDir);
        }
        catch (CruiseControlException e) {
            throw new RuntimeException(e);
        }
        return cmdLine;
    }

    String getProjectFilePath() {
        String projectFilePath = this.localWorkingDir.getAbsolutePath() + File.separator + this.project;
        if (!new File(projectFilePath).exists()) {
            throw new RuntimeException("project file not found at " + projectFilePath);
        }
        return projectFilePath;
    }

    private void setUserNameAndComment(Modification modification, String folderName, String fileName) {
        try {
            Commandline commandLine = new Commandline();
            commandLine.setExecutable("si");
            if (this.localWorkingDir != null) {
                commandLine.setWorkingDirectory(this.localWorkingDir.getAbsolutePath());
            }
            commandLine.createArgument("rlog");
            commandLine.createArgument("--format={author};{description}");
            commandLine.createArgument("--noHeaderFormat");
            commandLine.createArgument("--noTrailerFormat");
            commandLine.createArguments("-r", modification.revision);
            commandLine.createArgument(folderName + File.separator + fileName);
            Process proc = commandLine.execute();
            UserAndCommentConsumer userData = new UserAndCommentConsumer();
            Processes.waitFor(proc, userData, StreamLogger.getWarnLogger(LOG));
            if (userData.wasFound()) {
                modification.userName = userData.getUserName();
                modification.comment = userData.getComment();
            } else {
                LOG.warn((Object)("could not find username or comment for " + fileName + " r" + modification.revision));
                modification.userName = "";
                modification.comment = "";
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            modification.userName = "";
            modification.comment = "";
        }
    }

    private static class UserAndCommentConsumer
    implements StreamConsumer {
        private boolean found;
        private String userName;
        private String comment;

        private UserAndCommentConsumer() {
        }

        public boolean wasFound() {
            return this.found;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getComment() {
            return this.comment;
        }

        public void consumeLine(String line) {
            if (this.found) {
                return;
            }
            int idx = line.indexOf(";");
            if (idx == -1) {
                LOG.debug((Object)line);
                return;
            }
            this.found = true;
            this.userName = line.substring(0, idx);
            this.comment = idx < line.length() ? line.substring(idx + 1) : "";
        }
    }

    private final class ModificationsConsumer
    implements StreamConsumer {
        public List modifications;

        private ModificationsConsumer(List modifications) {
            this.modifications = modifications;
        }

        public void consumeLine(String line) {
            int idxCheckedOutRevision = line.indexOf(": checked out revision");
            if (idxCheckedOutRevision == -1) {
                return;
            }
            LOG.info((Object)line);
            int idxSeparator = line.lastIndexOf(File.separator);
            String folderName = line.substring(0, idxSeparator);
            String fileName = line.substring(idxSeparator + 1, idxCheckedOutRevision);
            Modification modification = new Modification();
            Modification.ModifiedFile modFile = modification.createModifiedFile(fileName, folderName);
            modification.modifiedTime = new Date(new File(folderName, fileName).lastModified());
            modification.revision = modFile.revision = line.substring(idxCheckedOutRevision + 23);
            MKS.this.setUserNameAndComment(modification, folderName, fileName);
            this.modifications.add(modification);
            MKS.this.properties.modificationFound();
        }
    }
}

