/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.sourcecontrols.FakeUserSourceControl;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvySourceControl
extends FakeUserSourceControl {
    private static final Logger LOG = Logger.getLogger(IvySourceControl.class);
    private File ivyXml = new File("ivy.xml");
    private File ivySettings = new File("ivysettings.xml");

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        try {
            return this.getModifications(lastBuild, this.artifacts());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertExists(this.ivyXml, "ivyXml", this.getClass());
        ValidationHelper.assertExists(this.ivySettings, "ivySettings", this.getClass());
    }

    protected List<Modification> getModifications(Date lastBuild, Collection<Artifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException("Cannot process null artifact collection");
        }
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Artifact artifact : artifacts) {
            if (artifact.getPublicationDate().compareTo(lastBuild) <= 0) continue;
            mods.add(this.modificationFor(artifact));
        }
        return mods;
    }

    Collection<Artifact> artifacts() throws IOException, ParseException {
        Ivy ivy = Ivy.newInstance();
        ivy.configure(this.ivySettings.toURI().toURL());
        return ivy.resolve(this.ivyXml.toURI().toURL()).getArtifacts();
    }

    private Modification modificationFor(Artifact artifact) {
        Modification modification = new Modification("ivy", this.getUserName(), "", null, artifact.getPublicationDate(), artifact.getId().toString(), new ArrayList<Modification.ModifiedFile>());
        Modification.ModifiedFile modfile = modification.createModifiedFile(artifact.getName(), this.folderFor(artifact.getUrl(), artifact.getName()));
        modfile.action = "change";
        return modification;
    }

    private String folderFor(URL url, String name) {
        return url.toString().replace("/" + name, "");
    }

    public String getIvyXml() {
        return this.ivyXml.getAbsolutePath();
    }

    public void setIvyXml(String ivyXml) {
        this.ivyXml = new File(ivyXml);
    }

    public void setIvySettings(String ivySettings) {
        this.ivySettings = new File(ivySettings);
    }

    public String getIvySettings() {
        return this.ivySettings.getAbsolutePath();
    }
}

