/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.sourcecontrols.FakeUserSourceControl;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFile
extends FakeUserSourceControl {
    private static final Logger LOG = Logger.getLogger(HttpFile.class);
    private String urlString;

    public void setURL(String urlString) {
        this.urlString = urlString;
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.urlString, "url", this.getClass());
        try {
            new URL(this.urlString);
        }
        catch (MalformedURLException e) {
            ValidationHelper.fail("'url' is not a valid connection string", e);
        }
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        long lastModified;
        URL url;
        try {
            url = new URL(this.urlString);
        }
        catch (MalformedURLException e) {
            return new ArrayList<Modification>();
        }
        try {
            lastModified = this.getURLLastModified(url);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not connect to 'url'", (Throwable)e);
            return new ArrayList<Modification>();
        }
        ArrayList<Modification> modifiedList = new ArrayList<Modification>();
        if (lastModified > lastBuild.getTime()) {
            Modification mod = new Modification("http");
            mod.createModifiedFile(this.getFilename(url), url.getHost());
            mod.userName = this.getUserName();
            mod.modifiedTime = new Date(lastModified);
            mod.comment = "";
            modifiedList.add(mod);
        }
        if (!modifiedList.isEmpty()) {
            this.getSourceControlProperties().modificationFound();
        }
        return modifiedList;
    }

    private String getFilename(URL url) {
        String fileName = url.getFile();
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    protected long getURLLastModified(URL url) throws IOException {
        URLConnection con = url.openConnection();
        long lastModified = con.getLastModified();
        try {
            con.getInputStream().close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return lastModified;
    }
}

