/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.sourcecontrols.FakeUserSourceControl;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystem
extends FakeUserSourceControl {
    private List<Modification> modifications;
    private File folder;
    private boolean includeDirectories;

    public void setFolder(String s) {
        this.folder = new File(s);
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.folder, "folder", this.getClass());
        ValidationHelper.assertTrue(this.folder.exists(), "folder " + this.folder.getAbsolutePath() + " must exist for FileSystem");
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        this.modifications = new ArrayList<Modification>();
        this.visit(this.folder, lastBuild.getTime());
        if (!this.modifications.isEmpty()) {
            this.getSourceControlProperties().modificationFound();
        }
        return this.modifications;
    }

    private void addRevision(File revision) {
        Modification mod = new Modification("filesystem");
        mod.userName = this.getUserName();
        Modification.ModifiedFile modfile = mod.createModifiedFile(revision.getName(), revision.getParent());
        modfile.action = "change";
        mod.modifiedTime = new Date(revision.lastModified());
        mod.comment = "";
        this.modifications.add(mod);
    }

    private void visit(File file, long lastBuild) {
        boolean isFile;
        if (file.isDirectory()) {
            String[] children;
            for (String child : children = file.list()) {
                this.visit(new File(file, child), lastBuild);
            }
        }
        boolean modified = file.lastModified() > lastBuild;
        boolean bl = isFile = !file.isDirectory();
        if (modified && (isFile || this.includeDirectories)) {
            this.addRevision(file);
        }
    }

    public void setIncludeDirectories(boolean b) {
        this.includeDirectories = b;
    }
}

