/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.CVSDateUtil;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.DiscardConsumer;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.OSEnvironment;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentVersionsSystem
implements SourceControl,
Cloneable {
    private static final long serialVersionUID = -3714548093682602092L;
    static final String OFFICIAL_CVS_NAME = "CVS";
    static final Version DEFAULT_CVS_SERVER_VERSION = new Version("CVS", "1.11");
    public static final String LOG_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss z";
    private boolean reallyQuiet;
    private String compression;
    private boolean recurseLocalWorkingCopy;
    private SourceControlProperties properties = new SourceControlProperties();
    private Hashtable mailAliases;
    private String cvsroot;
    private String local;
    private String tag;
    private String module;
    private Version cvsServerVersion;
    private boolean skipEmailsFetching = false;
    private static final Logger LOG = Logger.getLogger(ConcurrentVersionsSystem.class);
    private static final String CVS_FILE_DELIM = "=============================================================================";
    private static final String CVS_RCSFILE_LINE = "RCS file: ";
    private static final String CVS_WORKINGFILE_LINE = "Working file: ";
    private static final String CVS_REVISION_DELIM = "----------------------------";
    private static final String CVS_REVISION_DATE = "date:";
    private static final String CVS_HEAD_TAG = "HEAD";
    private static final String CVS_DESCRIPTION = "description:";
    private static final String CVS_REVISION_DEAD = "dead";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final SimpleDateFormat logDateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");

    public void setCvsRoot(String cvsroot) {
        this.cvsroot = cvsroot;
    }

    public void setLocalWorkingCopy(String local) {
        this.local = local;
    }

    public void setRecurseLocalWorkingCopy(boolean recurseLocalWorkingCopy) {
        this.recurseLocalWorkingCopy = recurseLocalWorkingCopy;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public void setReallyQuiet(boolean reallyQuiet) {
        this.reallyQuiet = reallyQuiet;
    }

    public void setCompression(String level) {
        this.compression = level;
    }

    public void setSkipEmailsFetching(boolean skipEmailsFetching) {
        this.skipEmailsFetching = skipEmailsFetching;
    }

    protected Version getCvsServerVersion() {
        if (this.cvsServerVersion == null) {
            Commandline commandLine = this.getCommandline();
            commandLine.setExecutable("cvs");
            if (this.cvsroot != null) {
                commandLine.createArguments("-d", this.cvsroot);
            }
            commandLine.createArgument().setLine("version");
            Process p = null;
            try {
                if (this.local != null) {
                    commandLine.setWorkingDirectory(this.local);
                }
                p = commandLine.execute();
                Thread stderr = ConcurrentVersionsSystem.logErrorStream(p);
                InputStream is = p.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                this.cvsServerVersion = this.extractCVSServerVersionFromCVSVersionCommandOutput(in);
                LOG.debug((Object)("cvs server version: " + this.cvsServerVersion));
                p.waitFor();
                stderr.join();
                IO.close(p);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed reading cvs server version", (Throwable)e);
            }
            catch (CruiseControlException e) {
                LOG.error((Object)"Failed reading cvs server version", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Failed reading cvs server version", (Throwable)e);
            }
            if (p == null || p.exitValue() != 0 || this.cvsServerVersion == null) {
                if (p == null) {
                    LOG.debug((Object)"Process p was null in CVS.getCvsServerVersion()");
                } else {
                    LOG.debug((Object)("Process exit value = " + p.exitValue()));
                }
                this.cvsServerVersion = DEFAULT_CVS_SERVER_VERSION;
                LOG.warn((Object)("problem getting cvs server version; using " + this.cvsServerVersion));
            }
        }
        return this.cvsServerVersion;
    }

    private Version extractCVSServerVersionFromCVSVersionCommandOutput(BufferedReader in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            return null;
        }
        if (line.startsWith("Client:")) {
            line = in.readLine();
            if (line == null) {
                return null;
            }
            if (!line.startsWith("Server:")) {
                LOG.warn((Object)("Warning expected a line starting with \"Server:\" but got " + line));
            }
        }
        LOG.debug((Object)("server version line: " + line));
        int nameBegin = line.indexOf(" (");
        int nameEnd = line.indexOf(") ", nameBegin);
        if (nameBegin == -1 || nameEnd < nameBegin || nameBegin + 2 >= line.length()) {
            LOG.warn((Object)("cvs server version name couldn't be parsed from " + line));
            return null;
        }
        String name = line.substring(nameBegin + 2, nameEnd);
        int verEnd = line.indexOf(" ", nameEnd + 2);
        if (verEnd < nameEnd + 2) {
            LOG.warn((Object)("cvs server version number couldn't be parsed from " + line));
            return null;
        }
        String version = line.substring(nameEnd + 2, verEnd);
        return new Version(name, version);
    }

    public boolean isCvsNewOutputFormat() {
        Version version = this.getCvsServerVersion();
        if (OFFICIAL_CVS_NAME.equals(version.getCvsName())) {
            String csv = version.getCvsVersion();
            StringTokenizer st = new StringTokenizer(csv, ".");
            try {
                st.nextToken();
                int subversion = Integer.parseInt(st.nextToken());
                if (subversion > 11) {
                    return subversion != 12 || Integer.parseInt(st.nextToken()) >= 9;
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"problem identifying cvs server. Assuming output is of 'old' type");
            }
        }
        return false;
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    protected OSEnvironment getOSEnvironment() {
        return new OSEnvironment();
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.local == null && (this.cvsroot == null || this.module == null), "must specify either 'localWorkingCopy' or 'cvsroot' and 'module' on CVS");
        ValidationHelper.assertFalse(this.local != null && (this.cvsroot != null || this.module != null), "if 'localWorkingCopy' is specified then cvsroot and module are not allowed on CVS");
        ValidationHelper.assertFalse(this.local == null && this.recurseLocalWorkingCopy, "'recurseLocalWorkingCopy' can only be set to true when 'localWorkingCopy' is specified.");
        ValidationHelper.assertFalse(this.local != null && !new File(this.local).exists(), "Local working copy \"" + this.local + "\" does not exist!");
        if (this.compression != null) {
            ValidationHelper.assertIntegerInRange(this.compression, 0, 9, "'compression' must be an integer between 0 and 9, inclusive.");
        }
    }

    public List getModifications(Date lastBuild, Date now) {
        this.mailAliases = this.getMailAliases();
        if (this.recurseLocalWorkingCopy && this.localDirectoryNotUnderCVS()) {
            return this.getModificationsFromSubdirectories(lastBuild, now);
        }
        List mods = null;
        try {
            mods = this.execHistoryCommand(this.buildHistoryCommand(lastBuild, now));
        }
        catch (Exception e) {
            LOG.error((Object)"Log command failed to execute successfully", (Throwable)e);
        }
        if (mods == null) {
            return new ArrayList();
        }
        return mods;
    }

    private List<Modification> getModificationsFromSubdirectories(Date lastBuild, Date now) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        File[] subDirectories = new File(this.local).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirectories == null) {
            return modifications;
        }
        for (File dir : subDirectories) {
            try {
                ConcurrentVersionsSystem delegate = (ConcurrentVersionsSystem)this.clone();
                delegate.setLocalWorkingCopy(dir.getPath());
                delegate.setSkipEmailsFetching(true);
                List modsFromSubdirectory = delegate.getModifications(lastBuild, now);
                for (Modification mod : modsFromSubdirectory) {
                    Iterator<Modification.ModifiedFile> i$ = mod.files.iterator();
                    while (i$.hasNext()) {
                        Modification.ModifiedFile o;
                        Modification.ModifiedFile modfile = o = i$.next();
                        modfile.folderName = dir.getName() + '/' + modfile.folderName;
                    }
                }
                modifications.addAll(modsFromSubdirectory);
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)"this should never happen", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return modifications;
    }

    private boolean localDirectoryNotUnderCVS() {
        File cvsDir = new File(this.local, OFFICIAL_CVS_NAME);
        return !cvsDir.exists() || !cvsDir.isDirectory();
    }

    private Hashtable getMailAliases() {
        if (this.mailAliases == null) {
            if (this.skipEmailsFetching) {
                this.mailAliases = new Hashtable();
                return this.mailAliases;
            }
            this.mailAliases = new Hashtable();
            Commandline commandLine = this.getCommandline();
            commandLine.setExecutable("cvs");
            if (this.cvsroot != null) {
                commandLine.createArguments("-d", this.cvsroot);
            }
            commandLine.createArgument().setLine("-q co -p CVSROOT/users");
            Process p = null;
            try {
                String line;
                if (this.local != null) {
                    commandLine.setWorkingDirectory(this.local);
                }
                p = commandLine.execute();
                Thread stderr = ConcurrentVersionsSystem.logErrorStream(p);
                InputStream is = p.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                while ((line = in.readLine()) != null) {
                    this.addAliasToMap(line);
                }
                p.waitFor();
                stderr.join();
                IO.close(p);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed reading mail aliases", (Throwable)e);
            }
            if (p == null || p.exitValue() != 0) {
                if (p == null) {
                    LOG.debug((Object)"Process p was null in CVS.getMailAliases()");
                } else {
                    LOG.debug((Object)("Process exit value = " + p.exitValue()));
                }
                LOG.warn((Object)"problem getting CVSROOT/users; using empty email map");
                this.mailAliases = new Hashtable();
            }
        }
        return this.mailAliases;
    }

    void addAliasToMap(String line) {
        LOG.debug((Object)("Mapping " + line));
        int colon = line.indexOf(58);
        if (colon >= 0) {
            String user = line.substring(0, colon);
            String address = line.substring(colon + 1);
            this.mailAliases.put(user, address);
        }
    }

    public Commandline buildHistoryCommand(Date lastBuildTime, Date checkTime) throws CruiseControlException {
        Commandline commandLine = this.getCommandline();
        commandLine.setExecutable("cvs");
        if (this.compression != null) {
            commandLine.createArgument("-z" + this.compression);
        }
        if (this.cvsroot != null) {
            commandLine.createArguments("-d", this.cvsroot);
        }
        commandLine.createArgument(this.reallyQuiet ? "-Q" : "-q");
        if (this.local != null) {
            commandLine.setWorkingDirectory(this.local);
            commandLine.createArgument("log");
        } else {
            commandLine.createArgument("rlog");
        }
        if (this.useHead()) {
            commandLine.createArgument("-N");
        }
        String dateRange = ConcurrentVersionsSystem.formatCVSDate(lastBuildTime) + "<" + ConcurrentVersionsSystem.formatCVSDate(checkTime);
        commandLine.createArgument("-d" + dateRange);
        if (!this.useHead()) {
            commandLine.createArgument("-r" + this.tag);
        } else {
            commandLine.createArgument("-b");
        }
        if (this.local == null) {
            commandLine.createArgument(this.module);
        }
        return commandLine;
    }

    protected Commandline getCommandline() {
        return new Commandline();
    }

    static String formatCVSDate(Date date) {
        return CVSDateUtil.formatCVSDate(date);
    }

    protected List parseStream(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = ConcurrentVersionsSystem.readToNotPast(reader, CVS_RCSFILE_LINE, null);
        ArrayList mods = new ArrayList();
        while (line != null) {
            List returnList = this.parseEntry(reader, line);
            mods.addAll(returnList);
            line = ConcurrentVersionsSystem.readToNotPast(reader, CVS_RCSFILE_LINE, null);
        }
        return mods;
    }

    private void getRidOfLeftoverData(InputStream stream) {
        new StreamPumper(stream, new DiscardConsumer()).run();
    }

    List execHistoryCommand(Commandline command) throws Exception {
        Process p = command.execute();
        Thread stderr = ConcurrentVersionsSystem.logErrorStream(p);
        InputStream cvsLogStream = p.getInputStream();
        List mods = this.parseStream(cvsLogStream);
        this.getRidOfLeftoverData(cvsLogStream);
        p.waitFor();
        stderr.join();
        IO.close(p);
        return mods;
    }

    protected void setMailAliases(Hashtable mailAliases) {
        this.mailAliases = mailAliases;
    }

    private static Thread logErrorStream(Process p) {
        return ConcurrentVersionsSystem.logErrorStream(p.getErrorStream());
    }

    static Thread logErrorStream(InputStream error) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, error));
        stderr.start();
        return stderr;
    }

    private List parseEntry(BufferedReader reader, String rcsLine) throws IOException {
        String workingFileName;
        ArrayList<Modification> mods = new ArrayList<Modification>();
        String nextLine = "";
        if (this.module != null && this.cvsroot != null) {
            String repositoryRoot = this.cvsroot.substring(this.cvsroot.lastIndexOf(":") + 1);
            int startAt = CVS_RCSFILE_LINE.length() + repositoryRoot.length();
            workingFileName = rcsLine.substring(startAt, rcsLine.length() - 2);
        } else {
            String workingFileLine = ConcurrentVersionsSystem.readToNotPast(reader, CVS_WORKINGFILE_LINE, null);
            workingFileName = workingFileLine.substring(CVS_WORKINGFILE_LINE.length());
        }
        String branchRevisionName = this.parseBranchRevisionName(reader);
        boolean newCVSVersion = this.isCvsNewOutputFormat();
        while (nextLine != null && !nextLine.startsWith(CVS_FILE_DELIM) && (nextLine = ConcurrentVersionsSystem.readToNotPast(reader, "revision", CVS_FILE_DELIM)) != null) {
            String itsBranchRevisionName;
            StringTokenizer tokens = new StringTokenizer(nextLine, " ");
            tokens.nextToken();
            String revision = tokens.nextToken();
            if (!this.useHead() && !revision.equals(branchRevisionName) && !(itsBranchRevisionName = revision.substring(0, revision.lastIndexOf(46))).equals(branchRevisionName) || (nextLine = ConcurrentVersionsSystem.readToNotPast(reader, CVS_REVISION_DATE, CVS_FILE_DELIM)) == null) break;
            tokens = new StringTokenizer(nextLine, " \t\n\r\f;");
            tokens.nextToken();
            String dateStamp = tokens.nextToken();
            String timeStamp = tokens.nextToken();
            String isThisTimeOffset = tokens.nextToken();
            if (!isThisTimeOffset.equals("author:")) {
                tokens.nextToken();
            }
            String authorName = tokens.nextToken();
            tokens.nextToken();
            String stateKeyword = tokens.nextToken();
            boolean isAdded = !tokens.hasMoreTokens();
            String message = "";
            nextLine = reader.readLine();
            boolean multiLine = false;
            while (nextLine != null && !nextLine.startsWith(CVS_FILE_DELIM) && !nextLine.startsWith(CVS_REVISION_DELIM)) {
                if (multiLine) {
                    message = message + NEW_LINE;
                } else {
                    multiLine = true;
                }
                message = message + nextLine;
                nextLine = reader.readLine();
            }
            Modification nextModification = new Modification("cvs");
            nextModification.revision = revision;
            int lastSlashIndex = workingFileName.lastIndexOf("/");
            String folderName = null;
            String fileName = workingFileName.substring(lastSlashIndex + 1);
            if (lastSlashIndex != -1) {
                folderName = workingFileName.substring(0, lastSlashIndex);
            }
            Modification.ModifiedFile modfile = nextModification.createModifiedFile(fileName, folderName);
            modfile.revision = nextModification.revision;
            try {
                nextModification.modifiedTime = newCVSVersion ? CVSDateUtil.parseCVSDate(dateStamp + " " + timeStamp + " GMT") : this.logDateFormatter.parse(dateStamp + " " + timeStamp + " GMT");
            }
            catch (ParseException pe) {
                LOG.error((Object)"Error parsing cvs LOG for date and time", (Throwable)pe);
                return null;
            }
            nextModification.userName = authorName;
            String address = (String)this.mailAliases.get(authorName);
            if (address != null) {
                nextModification.emailAddress = address;
            }
            nextModification.comment = message;
            if (stateKeyword.equalsIgnoreCase(CVS_REVISION_DEAD) && message.indexOf("was initially added on branch") != -1) {
                LOG.debug((Object)("skipping branch addition activity for " + nextModification));
                continue;
            }
            if (stateKeyword.equalsIgnoreCase(CVS_REVISION_DEAD)) {
                modfile.action = "deleted";
                this.properties.deletionFound();
            } else {
                modfile.action = isAdded ? "added" : "modified";
            }
            this.properties.modificationFound();
            mods.add(nextModification);
        }
        return mods;
    }

    private String parseBranchRevisionName(BufferedReader reader) throws IOException {
        String branchRevisionLine;
        String branchRevisionName = null;
        if (!this.useHead() && (branchRevisionLine = ConcurrentVersionsSystem.readToNotPast(reader, "\t" + this.tag + ": ", CVS_DESCRIPTION)) != null && (branchRevisionName = branchRevisionLine.substring(this.tag.length() + 3)).charAt(branchRevisionName.lastIndexOf(".") - 1) == '0') {
            branchRevisionName = branchRevisionName.substring(0, branchRevisionName.lastIndexOf(".") - 2) + branchRevisionName.substring(branchRevisionName.lastIndexOf("."));
        }
        return branchRevisionName;
    }

    private static String readToNotPast(BufferedReader reader, String beginsWith, String notPast) throws IOException {
        boolean checkingNotPast = notPast != null;
        String nextLine = reader.readLine();
        while (nextLine != null && !nextLine.startsWith(beginsWith)) {
            if (checkingNotPast && nextLine.startsWith(notPast)) {
                return null;
            }
            nextLine = reader.readLine();
        }
        return nextLine;
    }

    boolean useHead() {
        return this.tag == null || this.tag.equals(CVS_HEAD_TAG) || this.tag.equals("");
    }

    static class Version
    implements Serializable {
        private static final long serialVersionUID = -2433230091640056090L;
        private final String cvsName;
        private final String cvsVersion;

        public Version(String name, String version) {
            if (name == null) {
                throw new IllegalArgumentException("name can't be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("version can't be null");
            }
            this.cvsName = name;
            this.cvsVersion = version;
        }

        public String getCvsName() {
            return this.cvsName;
        }

        public String getCvsVersion() {
            return this.cvsVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version version = (Version)o;
            if (!this.cvsName.equals(version.cvsName)) {
                return false;
            }
            return this.cvsVersion.equals(version.cvsVersion);
        }

        public int hashCode() {
            int result = this.cvsName.hashCode();
            result = 29 * result + this.cvsVersion.hashCode();
            return result;
        }

        public String toString() {
            return this.cvsName + " " + this.cvsVersion;
        }
    }
}

