/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.cruisecontrol.Modification;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class ClearCaseModification
extends Modification {
    private static final String TAGNAME_LABEL = "label";
    private static final String TAGNAME_ATTRIBUTE = "attribute";
    private static final String TAGNAME_ATTRIBUTE_NAME = "name";
    private static final Logger LOG = Logger.getLogger(Modification.class);
    public List labels = null;
    public Map attributes = null;

    public ClearCaseModification() {
        super("clearcase");
    }

    public Element toElement() {
        Element modificationElement = super.toElement();
        if (this.labels != null) {
            Iterator<Object> it = this.labels.iterator();
            while (it.hasNext()) {
                Element labelElement = new Element(TAGNAME_LABEL);
                labelElement.addContent((String)it.next());
                modificationElement.addContent((Content)labelElement);
            }
        }
        if (this.attributes != null) {
            for (String attName : this.attributes.keySet()) {
                String attValue = (String)this.attributes.get(attName);
                Element attElement = new Element(TAGNAME_ATTRIBUTE);
                attElement.setAttribute(TAGNAME_ATTRIBUTE_NAME, attName);
                attElement.addContent(attValue);
                modificationElement.addContent((Content)attElement);
            }
        }
        return modificationElement;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        Iterator<Object> it = this.labels.iterator();
        while (it.hasNext()) {
            sb.append("Tag: ").append(it.next()).append('\n');
        }
        for (String attName : this.attributes.keySet()) {
            String attValue = (String)this.attributes.get(attName);
            sb.append("Attribute: ").append(attName).append(" = ").append(attValue).append('\n');
        }
        return sb.toString();
    }

    public void log() {
        if (LOG.isDebugEnabled()) {
            super.log();
            if (this.labels != null) {
                Iterator<Object> it = this.labels.iterator();
                while (it.hasNext()) {
                    LOG.debug((Object)("Tag: " + it.next()));
                }
            }
            if (this.attributes != null) {
                for (String attName : this.attributes.keySet()) {
                    String attValue = (String)this.attributes.get(attName);
                    LOG.debug((Object)("Attribute: " + attName + " = " + attValue));
                }
            }
            LOG.debug((Object)"");
            LOG.debug((Object)"");
        }
    }

    public void fromElement(Element modification) {
        List modAttrs;
        super.fromElement(modification);
        List modLabels = modification.getChildren(TAGNAME_LABEL);
        if (modLabels != null && modLabels.size() > 0) {
            this.labels = new Vector();
            for (Element label : modLabels) {
                this.labels.add(label.getText());
            }
        }
        if ((modAttrs = modification.getChildren(TAGNAME_ATTRIBUTE)) != null && modAttrs.size() > 0) {
            this.attributes = new HashMap();
            for (Element att : modAttrs) {
                String attName = att.getAttributeValue(TAGNAME_ATTRIBUTE_NAME);
                String attValue = att.getText();
                this.attributes.put(attName, attValue);
            }
        }
    }
}

