/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.ClearCaseModification;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.DiscardConsumer;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class ClearCase
implements SourceControl {
    private static final int DEFAULT = 0;
    private static final int DISABLED = 1;
    private static final int ENABLED = 2;
    private static final Logger LOG = Logger.getLogger(ClearCase.class);
    private final SourceControlProperties properties = new SourceControlProperties();
    private String viewPath;
    private String branch;
    private int recursive = 0;
    private int all = 0;
    private final SimpleDateFormat inDateFormatter = new SimpleDateFormat("dd-MMMM-yyyy.HH:mm:ss", Locale.US);
    private final SimpleDateFormat outDateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
    static final String DELIMITER = "#~#";
    static final String END_OF_STRING_DELIMITER = "@#@#@#@#@#@#@#@#@#@#@#@";

    public void setViewpath(String path) {
        this.viewPath = new File(path).getAbsolutePath();
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive ? 2 : 1;
    }

    public void setAll(boolean all) {
        int n = this.all = all ? 2 : 1;
        if (this.recursive == 0 && all) {
            this.recursive = 1;
        }
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.viewPath, "viewpath", this.getClass());
        if (this.recursive == 2 && this.all == 2) {
            ValidationHelper.fail("'recursive' and 'all' are mutually exclusive attributes for ClearCase");
        }
    }

    public List getModifications(Date lastBuild, Date now) {
        String lastBuildDate = this.inDateFormatter.format(lastBuild);
        this.properties.put("clearcaselastbuild", lastBuildDate);
        this.properties.put("clearcasenow", this.inDateFormatter.format(now));
        String command = "cleartool lshistory";
        if (this.branch != null) {
            command = command + " -branch " + this.branch;
        }
        if (this.recursive == 0 || this.recursive == 2) {
            command = command + " -r";
        } else if (this.all == 2) {
            command = command + " -all";
        }
        command = command + " -nco -since " + lastBuildDate;
        command = command + " -fmt %u#~#%Nd#~#%En#~#%Vn#~#%o#~#!%l#~#!%a#~#%Nc@#@#@#@#@#@#@#@#@#@#@#@\\n";
        File root = new File(this.viewPath);
        LOG.info((Object)("ClearCase: getting modifications for " + this.viewPath));
        LOG.debug((Object)("Command to execute : " + command));
        List modifications = null;
        try {
            Process p = Runtime.getRuntime().exec(command, null, root);
            p.getOutputStream().close();
            Thread stderr = this.logErrorStream(p);
            InputStream input = p.getInputStream();
            modifications = this.parseStream(input);
            this.getRidOfLeftoverData(input);
            p.waitFor();
            stderr.join();
            IO.close(p);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in executing the Clear Case command : ", (Throwable)e);
        }
        if (modifications == null) {
            modifications = new ArrayList();
        }
        return modifications;
    }

    private Thread logErrorStream(Process process) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, process));
        stderr.start();
        return stderr;
    }

    private void getRidOfLeftoverData(InputStream stream) {
        new StreamPumper(stream, new DiscardConsumer()).run();
    }

    List parseStream(InputStream input) throws IOException {
        String line;
        ArrayList<ClearCaseModification> modifications = new ArrayList<ClearCaseModification>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String ls = System.getProperty("line.separator");
        String lines = "";
        while ((line = reader.readLine()) != null) {
            if (!lines.equals("")) {
                lines = lines + ls;
            }
            lines = lines + line;
            ClearCaseModification mod = null;
            if (lines.indexOf(END_OF_STRING_DELIMITER) > -1) {
                mod = this.parseEntry(lines.substring(0, lines.indexOf(END_OF_STRING_DELIMITER)));
                lines = "";
            }
            if (mod == null) continue;
            modifications.add(mod);
        }
        return modifications;
    }

    private ClearCaseModification parseEntry(String line) {
        String fileName;
        String folderName;
        LOG.debug((Object)("parsing entry: " + line));
        String[] tokens = this.tokeniseEntry(line);
        if (tokens == null) {
            return null;
        }
        String username = tokens[0].trim();
        String timeStamp = tokens[1].trim();
        String elementName = tokens[2].trim();
        String version = tokens[3].trim();
        String operationType = tokens[4].trim();
        String labelList = tokens[5].substring(1).trim();
        Vector labels = this.extractLabelsList(labelList);
        String attributeList = tokens[6].substring(1).trim();
        Hashtable attributes = this.extractAttributesMap(attributeList);
        String comment = tokens[7].trim();
        if (operationType.equals("mkbranch") || operationType.equals("rmbranch")) {
            return null;
        }
        if (elementName.indexOf("@@") >= 0) {
            return null;
        }
        ClearCaseModification mod = new ClearCaseModification();
        mod.userName = username;
        mod.revision = version;
        int sep = elementName.lastIndexOf(File.separator);
        if (sep > -1) {
            folderName = elementName.substring(0, sep);
            fileName = elementName.substring(sep + 1);
        } else {
            folderName = null;
            fileName = elementName;
        }
        Modification.ModifiedFile modfile = mod.createModifiedFile(fileName, folderName);
        try {
            mod.modifiedTime = this.outDateFormatter.parse(timeStamp);
        }
        catch (ParseException e) {
            mod.modifiedTime = null;
        }
        modfile.action = operationType;
        modfile.revision = version;
        mod.type = "clearcase";
        mod.labels = labels;
        mod.attributes = attributes;
        mod.comment = comment;
        this.properties.modificationFound();
        return mod;
    }

    private String[] tokeniseEntry(String line) {
        int maxTokens = 8;
        int minTokens = maxTokens - 1;
        Object[] tokens = new String[maxTokens];
        Arrays.fill(tokens, "");
        int tokenIndex = 0;
        int oldIndex = 0;
        int index = line.indexOf(DELIMITER, 0);
        while (true) {
            if (tokenIndex > maxTokens) {
                LOG.debug((Object)"Too many tokens; skipping entry");
                return null;
            }
            if (index == -1) break;
            tokens[tokenIndex] = line.substring(oldIndex, index);
            oldIndex = index + DELIMITER.length();
            index = line.indexOf(DELIMITER, oldIndex);
            ++tokenIndex;
        }
        tokens[tokenIndex] = line.substring(oldIndex);
        if (tokenIndex < minTokens) {
            LOG.debug((Object)"Not enough tokens; skipping entry");
            return null;
        }
        return tokens;
    }

    private Hashtable extractAttributesMap(String attributeList) {
        Hashtable<String, String> attributes = null;
        if (attributeList.length() > 0) {
            attributes = new Hashtable<String, String>();
            StringTokenizer attrST = new StringTokenizer(attributeList, "(), ");
            while (attrST.hasMoreTokens()) {
                String attr = attrST.nextToken();
                int idx = attr.indexOf(61);
                if (idx <= 0) continue;
                String attrName = attr.substring(0, idx);
                String attrValue = attr.substring(idx + 1);
                if (attrValue.startsWith("\"")) {
                    attrValue = attrValue.substring(1, attrValue.length() - 1);
                }
                attributes.put(attrName, attrValue);
            }
        }
        return attributes;
    }

    private Vector extractLabelsList(String labelList) {
        Vector<String> labels = null;
        if (labelList.length() > 0) {
            labels = new Vector<String>();
            StringTokenizer labelST = new StringTokenizer(labelList, "(), ");
            while (labelST.hasMoreTokens()) {
                labels.add(labelST.nextToken().trim());
            }
        }
        return labels;
    }
}

