/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Log;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatus
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(BuildStatus.class);
    public static final String MOST_RECENT_LOGDIR_KEY = "most.recent.logdir";
    public static final String MOST_RECENT_LOGFILE_KEY = "most.recent.logfile";
    public static final String MOST_RECENT_LOGTIME_KEY = "most.recent.logtime";
    public static final String MOST_RECENT_LOGLABEL_KEY = "most.recent.loglabel";
    private final SourceControlProperties properties = new SourceControlProperties();
    private String logDir;
    private boolean vetoIfFailing = false;

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.logDir, "logdir", this.getClass());
        File logDirectory = new File(this.logDir);
        ValidationHelper.assertTrue(logDirectory.exists(), "Log directory does not exist: " + logDirectory.getAbsolutePath());
        ValidationHelper.assertTrue(logDirectory.isDirectory(), "Log directory is not a directory: " + logDirectory.getAbsolutePath());
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date unused) {
        this.properties.put(MOST_RECENT_LOGDIR_KEY, this.logDir);
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        File logDirectory = new File(this.logDir);
        final String filename = Log.formatLogFileName(lastBuild);
        if (!logDirectory.exists()) {
            LOG.error((Object)("log directory doesn't exist: " + this.logDir));
            return modifications;
        }
        if (!logDirectory.isDirectory()) {
            LOG.error((Object)("path for log directory exists but isn't a directory: " + this.logDir));
            return modifications;
        }
        if (this.vetoIfFailing) {
            this.vetoIfFailing(logDirectory);
        }
        try {
            File[] newLogs = logDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.compareTo(filename) > 0 && Log.wasSuccessfulBuild(name);
                }
            });
            Modification mostRecent = null;
            for (File newLog : newLogs) {
                Modification modification = new Modification("buildstatus");
                String name = newLog.getName();
                modification.modifiedTime = Log.parseDateFromLogFileName(name);
                modification.userName = "cc-" + this.getProjectFromLog(newLog);
                modification.comment = this.logDir.substring(this.logDir.lastIndexOf(47) + 1);
                modification.revision = Log.parseLabelFromLogFileName(name);
                Modification.ModifiedFile modfile = modification.createModifiedFile(name, null);
                modfile.revision = modification.revision;
                modfile.action = "add";
                if (mostRecent == null || modification.modifiedTime.after(mostRecent.modifiedTime)) {
                    mostRecent = modification;
                }
                modifications.add(modification);
            }
            if (mostRecent != null) {
                this.properties.put(MOST_RECENT_LOGFILE_KEY, mostRecent.files.get((int)0).fileName);
                this.properties.put(MOST_RECENT_LOGTIME_KEY, DateUtil.getFormattedTime(mostRecent.modifiedTime));
                this.properties.put(MOST_RECENT_LOGLABEL_KEY, mostRecent.revision);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking for modifications", (Throwable)e);
        }
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
        }
        return modifications;
    }

    private void vetoIfFailing(File logDirectory) {
        NewestLogfileFilter filter = new NewestLogfileFilter();
        logDirectory.listFiles(filter);
        String mostRecentLogfileName = filter.mostRecent;
        if (mostRecentLogfileName != null && !Log.wasSuccessfulBuild(mostRecentLogfileName)) {
            throw new VetoException("most recent build failed: " + mostRecentLogfileName);
        }
    }

    private String getProjectFromLog(File f) {
        LOG.info((Object)("Getting project from file: " + f.getName()));
        try {
            Document doc = this.readDocFromFile(f);
            LOG.info((Object)"Loaded xml document for BuildStatus");
            Element root = doc.getRootElement();
            XMLLogHelper log = new XMLLogHelper(root);
            return log.getProjectName();
        }
        catch (JDOMException ex) {
            LOG.info((Object)("Failed to load BuildStatus xml document" + (Object)((Object)ex)));
        }
        catch (IOException ex) {
            LOG.info((Object)("Failed to load BuildStatus xml document" + ex));
        }
        catch (CruiseControlException ex) {
            LOG.info((Object)("Could load BuildStatus xml log document, but generated exception anyway" + ex));
        }
        return "Unknown";
    }

    private Document readDocFromFile(File f) throws JDOMException, IOException {
        SAXBuilder sxb = new SAXBuilder();
        return sxb.build(f);
    }

    public void setVetoIfFailing(boolean b) {
        this.vetoIfFailing = b;
    }

    private static class NewestLogfileFilter
    implements FilenameFilter {
        private String mostRecent;

        private NewestLogfileFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean accept;
            boolean bl = accept = name.startsWith("log") && name.endsWith(".xml") && name.length() >= this.minimumFilenameLength();
            if (accept) {
                this.cacheNewestFilename(name);
            }
            return accept;
        }

        private void cacheNewestFilename(String name) {
            try {
                Date logDate = Log.parseDateFromLogFileName(name);
                if (this.mostRecent == null || logDate.after(Log.parseDateFromLogFileName(this.mostRecent))) {
                    this.mostRecent = name;
                }
            }
            catch (CruiseControlException e) {
                LOG.warn((Object)("exception getting date from filename: " + name), (Throwable)e);
            }
        }

        private int minimumFilenameLength() {
            return "log".length() + "yyyyMMddHHmmss".length() + ".xml".length();
        }
    }

    private static class VetoException
    extends RuntimeException {
        public VetoException(String message) {
            super(message);
        }
    }
}

