/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.report;

import java.util.TimerTask;
import net.sourceforge.cruisecontrol.BuildLoopInformationBuilder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;

public class BuildLoopStatusReportTask
extends TimerTask {
    private BuildLoopInformationBuilder builder;
    private static final Logger LOGGER = Logger.getLogger(BuildLoopStatusReportTask.class);
    private HttpClient http;
    private String url;
    private String sent;
    private String response;

    public BuildLoopStatusReportTask(BuildLoopInformationBuilder builder, String url) {
        this(builder, url, new HttpClient(), 3000);
    }

    public BuildLoopStatusReportTask(BuildLoopInformationBuilder builder, String url, HttpClient http, int timeout) {
        this.builder = builder;
        this.url = url;
        this.http = http;
        this.http.getParams().setSoTimeout(timeout);
    }

    public void run() {
        this.run(new PostMethod(this.url));
    }

    public String getSent() {
        return this.sent;
    }

    public String getReponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PostMethod postMethod) {
        try {
            this.sent = this.builder.buildBuildLoopInformation().toXml();
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(this.sent));
            this.http.executeMethod((HttpMethod)postMethod);
            this.response = new String(postMethod.getResponseBody());
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to reach dashboard instance : " + this.url + ", either the dashboard has not started up or there is a network problem."), (Throwable)e);
        }
        finally {
            postMethod.releaseConnection();
        }
    }
}

