/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.report;

import java.util.Timer;
import net.sourceforge.cruisecontrol.BuildLoopInformationBuilder;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.report.BuildLoopMonitor;
import net.sourceforge.cruisecontrol.report.BuildLoopPostingConfiguration;
import net.sourceforge.cruisecontrol.report.BuildLoopStatusReportTask;

public final class BuildLoopMonitorRepository {
    private static BuildLoopMonitor buildLoopMonitor;
    private static BuildLoopPostingConfiguration config;

    private BuildLoopMonitorRepository() {
    }

    public static BuildLoopMonitor getBuildLoopMonitor() {
        return buildLoopMonitor;
    }

    public static BuildLoopPostingConfiguration getBuildLoopMonitorConfig() {
        return config;
    }

    public static void cancelExistingAndStartNewPosting(CruiseControlController controller, BuildLoopPostingConfiguration config) {
        BuildLoopMonitorRepository.cancelPosting();
        BuildLoopMonitorRepository.createAndStartBuildLoopMonitor(controller, config);
    }

    public static void cancelPosting() {
        if (buildLoopMonitor != null) {
            buildLoopMonitor.cancel();
            buildLoopMonitor = null;
            config = null;
        }
    }

    private static void createAndStartBuildLoopMonitor(CruiseControlController controller, BuildLoopPostingConfiguration config) {
        BuildLoopInformationBuilder builder = new BuildLoopInformationBuilder(controller);
        BuildLoopStatusReportTask task = new BuildLoopStatusReportTask(builder, config.getUrl() + "/buildloop/listener");
        buildLoopMonitor = new BuildLoopMonitor(new Timer(), task, config.getInterval() * 1000L);
        buildLoopMonitor.start();
        BuildLoopMonitorRepository.config = config;
    }
}

