/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.sfee;

import com.vasoftware.sf.soap42.types.SoapNamedValues;
import com.vasoftware.sf.soap42.webservices.ClientSoapStubFactory;
import com.vasoftware.sf.soap42.webservices.sfmain.ISourceForgeSoap;
import com.vasoftware.sf.soap42.webservices.tracker.ITrackerAppSoap;
import com.vasoftware.sf.soap42.webservices.tracker.TrackerSoapList;
import com.vasoftware.sf.soap42.webservices.tracker.TrackerSoapRow;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.sfee.SfeePublisher;
import net.sourceforge.cruisecontrol.publishers.sfee.SfeeUtils;
import net.sourceforge.cruisecontrol.util.NamedXPathAwareChild;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XPathAwareChild;
import org.jdom.Element;

public class SfeeTrackerPublisher
extends SfeePublisher {
    private String trackerName;
    private final Collection fields = new ArrayList();
    private String projectName;
    private XPathAwareChild title;
    private XPathAwareChild description;
    private XPathAwareChild status;

    public void setTrackerName(String name) {
        this.trackerName = name;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public NamedXPathAwareChild createField() {
        NamedXPathAwareChild field = new NamedXPathAwareChild();
        this.fields.add(field);
        return field;
    }

    public XPathAwareChild createTitle() {
        this.title = new XPathAwareChild();
        return this.title;
    }

    public XPathAwareChild createDescription() {
        this.description = new XPathAwareChild();
        return this.description;
    }

    public XPathAwareChild createStatus() {
        this.status = new XPathAwareChild();
        return this.status;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        ISourceForgeSoap soapStub = (ISourceForgeSoap)ClientSoapStubFactory.getSoapStub(ISourceForgeSoap.class, (String)this.getServerURL());
        try {
            String sessionID = soapStub.login(this.getUsername(), this.getPassword());
            String projectID = SfeeUtils.findProjectID(soapStub, sessionID, this.projectName);
            ITrackerAppSoap tracker = (ITrackerAppSoap)ClientSoapStubFactory.getSoapStub(ITrackerAppSoap.class, (String)this.getServerURL());
            TrackerSoapList trackerList = tracker.getTrackerList(sessionID, projectID);
            TrackerSoapRow[] trackerListRows = trackerList.getDataRows();
            String trackerID = null;
            for (int i = 0; i < trackerListRows.length; ++i) {
                TrackerSoapRow trackerListRow = trackerListRows[i];
                String nextTitle = trackerListRow.getTitle();
                if (!nextTitle.equals(this.trackerName)) continue;
                trackerID = trackerListRow.getId();
            }
            SfeeUtils.assertFoundValue(trackerID, "trackerName", this.trackerName);
            tracker.createArtifact(sessionID, trackerID, this.title.lookupValue(cruisecontrolLog), this.description.lookupValue(cruisecontrolLog), null, null, this.status.lookupValue(cruisecontrolLog), null, 0, 0, null, null, this.buildFlexFields(cruisecontrolLog), null, null, null);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
    }

    private SoapNamedValues buildFlexFields(Element log) throws CruiseControlException {
        SoapNamedValues namedValues = new SoapNamedValues();
        String[] names = new String[this.fields.size()];
        String[] values = new String[this.fields.size()];
        int i = 0;
        for (NamedXPathAwareChild nextField : this.fields) {
            names[i] = nextField.getName();
            values[i] = nextField.lookupValue(log);
            ++i;
        }
        namedValues.setNames(names);
        namedValues.setValues(values);
        return namedValues;
    }

    public void subValidate() throws CruiseControlException {
        ValidationHelper.assertNotEmpty(this.projectName, "projectName", this.getClass());
        ValidationHelper.assertNotEmpty(this.trackerName, "trackerName", this.getClass());
        ValidationHelper.assertHasChild(this.title, "title", this.getClass());
        ValidationHelper.assertHasChild(this.description, "description", this.getClass());
        ValidationHelper.assertHasChild(this.status, "status", this.getClass());
        this.title.validate();
        this.description.validate();
        this.status.validate();
        for (NamedXPathAwareChild nextField : this.fields) {
            nextField.validate();
        }
    }
}

