/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.rss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.cruisecontrol.publishers.rss.Item;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Feed {
    private static final Logger LOG = Logger.getLogger(Feed.class);
    private String channelTitle;
    private String channelLink;
    private String channelDescription;
    private String channelLanguage = "en-US";
    private int maxLength = 20;
    private final List items = new ArrayList();

    public Feed(File publishToFile) {
        if (publishToFile.exists() && publishToFile.canRead()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(publishToFile);
                if (doc.getRootElement() != null && doc.getRootElement().getChild("channel") != null) {
                    Element channelElement = doc.getRootElement().getChild("channel");
                    if (channelElement.getChild("title") != null) {
                        this.channelTitle = channelElement.getChild("title").getText().trim();
                    }
                    if (channelElement.getChild("link") != null) {
                        this.channelLink = channelElement.getChild("link").getText().trim();
                    }
                    if (channelElement.getChild("description") != null) {
                        this.channelDescription = channelElement.getChild("description").getText().trim();
                    }
                    if (channelElement.getChildren("item") != null) {
                        List itemNodes = channelElement.getChildren("item");
                        for (int i = 0; i < itemNodes.size(); ++i) {
                            this.items.add(new Item((Element)itemNodes.get(i)));
                        }
                    }
                } else {
                    LOG.info((Object)"existing RSS file doesn't appear to be valid.  Missnig root element or channel node.");
                }
                Collections.sort(this.items);
                while (this.items.size() > this.maxLength) {
                    this.items.remove(this.items.size() - 1);
                }
            }
            catch (JDOMException jex) {
                LOG.error((Object)("jdom exception while parsing existing RSS file " + publishToFile.getPath() + "; deleting file and starting over..."), (Throwable)jex);
                publishToFile.delete();
            }
            catch (IOException ioe) {
                LOG.error((Object)("IOException while reading existing RSS file " + publishToFile.getPath() + "; deleting file and starting over..."), (Throwable)ioe);
                publishToFile.delete();
            }
        } else {
            LOG.info((Object)"Unable to locate or read the existing RSS feed file.");
        }
    }

    public void setTitle(String title) {
        this.channelTitle = title;
    }

    public String getTitle() {
        return this.channelTitle;
    }

    public void setLink(String link) {
        this.channelLink = link;
    }

    public String getLink() {
        return this.channelLink;
    }

    public void setDescription(String description) {
        this.channelDescription = description;
    }

    public String getDescription() {
        return this.channelDescription;
    }

    public void setMaxLength(int max) {
        this.maxLength = max;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List list = this.items;
        synchronized (list) {
            if (this.items.size() == this.maxLength) {
                this.items.remove(this.items.size() - 1);
            }
            this.items.add(0, item);
        }
    }

    public List getItems() {
        return this.items;
    }

    public void write(Writer wr) throws IOException {
        BufferedWriter br = new BufferedWriter(wr);
        br.write("<?xml version=\"1.0\" ?>\n");
        br.write("<rss version=\"2.0\">\n");
        br.write("  <channel>\n");
        br.write("    <title>");
        if (this.getTitle() != null) {
            br.write(this.getTitle());
        }
        br.write("</title>\n");
        br.write("    <link>");
        if (this.getLink() != null) {
            br.write(this.getLink());
        }
        br.write("</link>\n");
        br.write("    <description>");
        if (this.getDescription() != null) {
            br.write(this.getDescription());
        }
        br.write("</description>\n");
        br.write("    <language>");
        br.write(this.channelLanguage);
        br.write("</language>\n");
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == null) continue;
            Item item = (Item)this.items.get(i);
            br.write(item.toXml());
        }
        br.write("  </channel>\n");
        br.write("</rss>\n");
        br.flush();
    }
}

