/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.email;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class MavenMapperHelper {
    private final String projectFile;
    private Properties props;
    private List developerNodes;
    private String[] mandatoryElements;
    private static final String[] MANDATORY_ELEMENTS_DEFAULT = new String[]{"id", "email"};
    private static final String X_PATH_EXPRESSION = "/project//developers//developer";

    public MavenMapperHelper(String projectFile) throws CruiseControlException {
        this.projectFile = projectFile;
        this.props = new Properties();
        this.setMandatoryElements(MANDATORY_ELEMENTS_DEFAULT);
        this.setDeveloperNodes();
        this.setDeveloperPropertySet();
    }

    public Properties getDeveloperPropertySet() {
        return this.props;
    }

    public void setMandatoryElements(String[] mandatoryElementsDefault) {
        this.mandatoryElements = mandatoryElementsDefault;
    }

    private void setDeveloperNodes() throws CruiseControlException {
        SAXBuilder builder = new SAXBuilder(false);
        try {
            Document doc = builder.build((InputStream)new FileInputStream(this.projectFile));
            this.developerNodes = XPath.selectNodes((Object)doc, (String)X_PATH_EXPRESSION);
        }
        catch (IOException io) {
            throw new CruiseControlException("Cannot open Maven POM " + this.projectFile + ": " + io.getLocalizedMessage());
        }
        catch (JDOMException jde) {
            throw new CruiseControlException(this.projectFile + "causes XML-Problems: " + jde.getLocalizedMessage());
        }
    }

    private void setDeveloperPropertySet() throws CruiseControlException {
        for (int i = 0; i < this.developerNodes.size(); ++i) {
            Element developerEntry = (Element)this.developerNodes.get(i);
            for (int j = 0; j < this.mandatoryElements.length; ++j) {
                Element mandatoryElement = developerEntry.getChild(this.mandatoryElements[j]);
                if (mandatoryElement != null) continue;
                throw new CruiseControlException("MavenMapper: Missing <" + this.mandatoryElements[j] + "> child element on " + developerEntry.toString() + " in " + this.projectFile);
            }
            List children = developerEntry.getChildren();
            String developerId = developerEntry.getChild("id").getText();
            for (int k = 0; k < children.size(); ++k) {
                Element nextNode = (Element)children.get(k);
                this.props.setProperty(developerId + "." + nextNode.getName(), nextNode.getValue());
            }
        }
    }
}

