/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.email;

import java.io.File;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.email.EmailAddressMapper;
import net.sourceforge.cruisecontrol.publishers.email.MavenMapperHelper;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class MavenMapper
extends EmailAddressMapper {
    private static final long serialVersionUID = -2121211825257529130L;
    private static final Logger LOG = Logger.getLogger(MavenMapper.class);
    private String projectFile = null;
    private Properties props = new Properties();

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public void open() throws CruiseControlException {
        MavenMapperHelper mmh = new MavenMapperHelper(this.projectFile);
        this.props = mmh.getDeveloperPropertySet();
        LOG.debug((Object)("DeveloperPropertySet: " + this.props));
    }

    public void validate() throws CruiseControlException {
        File f = new File(this.projectFile);
        ValidationHelper.assertIsSet((Object)this.projectFile, "projectFile", this.getClass());
        ValidationHelper.assertFalse(this.projectFile.equals(""), "empty string is not a valid value of projectFile for " + this.getClass().getName());
        ValidationHelper.assertExists(f, "projectFile", this.getClass());
        ValidationHelper.assertIsReadable(f, "projectFile", this.getClass());
        if (!f.isFile()) {
            throw new CruiseControlException(this.projectFile + " is not a file");
        }
    }

    public String mapUser(String user) {
        return this.props.getProperty(user + ".email");
    }
}

