/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.email;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.email.EmailAddressMapper;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class LDAPMapper
extends EmailAddressMapper {
    private static final Logger LOG = Logger.getLogger(LDAPMapper.class);
    private String url = null;
    private String ctxFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String bindDN = null;
    private String bindPassword = null;
    private String rootDN = null;
    private String searchTmpl = "(cn=?)";
    private String searchAttr = "mail";
    private DirContext ctx = null;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setRootDN(String rootDN) {
        this.rootDN = rootDN;
    }

    public String getRootDN() {
        return this.rootDN;
    }

    public void setSearchTmpl(String searchTmpl) {
        this.searchTmpl = searchTmpl;
    }

    public String getSearchTmpl() {
        return this.searchTmpl;
    }

    public void setSearchAttr(String searchAttr) {
        this.searchAttr = searchAttr;
    }

    public String getSearchAttr() {
        return this.searchAttr;
    }

    public void setCtxfactory(String ctxFactory) {
        this.ctxFactory = ctxFactory;
    }

    public String getCtxFactory() {
        return this.ctxFactory;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getUrl(), "url", this.getClass());
        ValidationHelper.assertIsSet((Object)this.getRootDN(), "rootDN", this.getClass());
        ValidationHelper.assertIsDependentSet(this.getBindDN(), "bindDN", this.getBindPassword(), "bindPassword", this.getClass());
    }

    public void open() throws CruiseControlException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.ctxFactory);
        env.put("java.naming.provider.url", this.url);
        if (this.bindDN != null & this.bindPassword != null) {
            env.put("java.naming.security.principal", this.bindDN);
            env.put("java.naming.security.credentials", this.bindPassword);
        }
        try {
            this.ctx = new InitialDirContext(env);
            LOG.debug((Object)"LDAPMapper: InitialContext created.");
        }
        catch (Exception e) {
            throw new CruiseControlException(e);
        }
    }

    public void close() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
                LOG.debug((Object)"LDAPMapper: InitialContext closed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String mapUser(String user) {
        String[] searchAttrs = new String[]{this.searchAttr};
        SearchControls constraints1 = new SearchControls();
        constraints1.setSearchScope(2);
        constraints1.setCountLimit(0L);
        constraints1.setTimeLimit(0);
        constraints1.setReturningAttributes(searchAttrs);
        String email = null;
        StringBuffer s = new StringBuffer(this.searchTmpl);
        int idx = s.toString().indexOf("?");
        s.replace(idx, idx + 1, user);
        try {
            NamingEnumeration<SearchResult> ne = this.ctx.search(this.rootDN, s.toString(), constraints1);
            while (ne.hasMore()) {
                SearchResult o = ne.next();
                Attributes attrs = o.getAttributes();
                Attribute emailAttr = attrs.get(this.searchAttr);
                email = (String)emailAttr.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOG.debug((Object)("LDAPMapper: Mapping " + user + " to " + email));
        return email;
    }
}

