/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.publishers.rss.CruiseControlFeed;
import net.sourceforge.cruisecontrol.publishers.rss.CruiseControlItem;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class RSSPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(RSSPublisher.class);
    private static Map rssFeeds = new HashMap();
    private String fileName;
    private String buildresultsurl;
    private String channelLinkURL;
    private int maxLength = 10;
    private CruiseControlFeed rssFeed;

    public static CruiseControlFeed getRSSFeed(File publishToFile) {
        String pathToPublishFile;
        try {
            pathToPublishFile = publishToFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            pathToPublishFile = publishToFile.getAbsolutePath().toLowerCase();
        }
        CruiseControlFeed rssfeed = (CruiseControlFeed)rssFeeds.get(pathToPublishFile);
        if (rssfeed == null) {
            rssfeed = new CruiseControlFeed(publishToFile);
            rssFeeds.put(pathToPublishFile, rssfeed);
        }
        rssfeed.incrementProjectCount();
        return rssfeed;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        if (this.rssFeed == null) {
            this.rssFeed = RSSPublisher.getRSSFeed(new File(this.fileName));
            this.rssFeed.setProjectName(helper.getProjectName());
            this.rssFeed.setMaxLength(this.maxLength);
            this.rssFeed.setLink(this.channelLinkURL);
        }
        CruiseControlItem rssItem = new CruiseControlItem(helper, this.buildresultsurl);
        this.rssFeed.addItem(rssItem);
        this.publishFeed();
    }

    protected void publishFeed() throws CruiseControlException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.fileName);
            this.rssFeed.write(fw);
        }
        catch (IOException ioe) {
            try {
                throw new CruiseControlException("Error writing file: " + this.fileName, ioe);
            }
            catch (Throwable throwable) {
                IO.close(fw);
                throw throwable;
            }
        }
        IO.close(fw);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.fileName, "filename", this.getClass());
        ValidationHelper.assertIsSet((Object)this.buildresultsurl, "buildresultsurl", this.getClass());
    }

    public void setFile(String fileName) {
        this.fileName = fileName.trim();
    }

    public void setBuildResultsURL(String buildResultsURL) {
        this.buildresultsurl = buildResultsURL.trim();
    }

    public void setChannelLinkURL(String channelLinkURL) {
        this.channelLinkURL = channelLinkURL.trim();
    }

    public void setMaxLength(int max) {
        if (max > 0) {
            this.maxLength = max;
        } else {
            LOG.warn((Object)("ignoring command to set maxRecords to invalud value (" + max + ");"));
        }
    }
}

