/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.JabberPublisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;

public class LinkJabberPublisher
extends JabberPublisher {
    private String buildResultsURL;

    public void setBuildResultsURL(String buildResultsURL) {
        this.buildResultsURL = buildResultsURL;
    }

    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.buildResultsURL, "buildresulturl", this.getClass());
    }

    protected String createMessage(XMLLogHelper logHelper) throws CruiseControlException {
        String logFileName = logHelper.getLogFileName();
        String baseLogFileName = logFileName.substring(logFileName.lastIndexOf(File.separator) + 1, logFileName.lastIndexOf("."));
        StringBuffer message = new StringBuffer();
        message.append("Build results for ");
        message.append(logHelper.isBuildSuccessful() ? "successful" : "failed");
        message.append(" build of project ");
        message.append(logHelper.getProjectName());
        message.append(": ");
        message.append(this.buildResultsURL);
        if (this.buildResultsURL.indexOf("?") == -1) {
            message.append("?");
        } else {
            message.append("&");
        }
        message.append("log=");
        message.append(baseLogFileName);
        return message.toString();
    }
}

