/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public abstract class JabberPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(JabberPublisher.class);
    private String host;
    private int port = 5222;
    private String username;
    private String password;
    private String recipient;
    private String service;
    private boolean chatroom = false;
    private boolean ssl = false;
    private static XMPPConnection connection;
    private Chat chat;
    private GroupChat groupchat;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setChatroom(boolean chatroom) {
        this.chatroom = chatroom;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    protected void init() {
        if (null == connection || this.requiresReconnect()) {
            try {
                connection = this.ssl ? (this.service != null ? new SSLXMPPConnection(this.host, this.port, this.service) : new SSLXMPPConnection(this.host, this.port)) : (this.service != null ? new XMPPConnection(this.host, this.port, this.service) : new XMPPConnection(this.host, this.port));
            }
            catch (XMPPException e) {
                LOG.error((Object)"Error initializing jabber connection", (Throwable)e);
            }
            try {
                connection.login(this.username, this.password);
            }
            catch (XMPPException e) {
                LOG.error((Object)"Authentication error on login", (Throwable)e);
            }
        }
        try {
            if (this.chatroom) {
                this.groupchat = connection.createGroupChat(this.recipient);
                this.groupchat.join(this.username);
            } else {
                this.chat = connection.createChat(this.recipient);
            }
        }
        catch (XMPPException e) {
            LOG.error((Object)"Could not send message to recipient or chat room", (Throwable)e);
        }
    }

    private boolean requiresReconnect() {
        return !connection.isConnected() && !connection.isSecureConnection() || !connection.isAuthenticated();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.host, "host", this.getClass());
        ValidationHelper.assertIsSet((Object)this.username, "username", this.getClass());
        ValidationHelper.assertFalse(this.isEmail(this.username), "'username' is not in correct format. 'username' should not be of the form user@domain.com");
        ValidationHelper.assertIsSet((Object)this.password, "password", this.getClass());
        ValidationHelper.assertIsSet((Object)this.recipient, "recipient", this.getClass());
        ValidationHelper.assertTrue(this.isEmail(this.recipient), "'recipient' is not in correct format. 'recipient' should be of the form user@domain.com");
    }

    private boolean isEmail(String username) {
        return username.indexOf("@") != -1;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        this.init();
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        String message = this.createMessage(helper);
        try {
            if (this.chatroom) {
                LOG.debug((Object)("sending to chat room (" + this.recipient + ") the message: " + message));
                this.groupchat.sendMessage(message);
            } else {
                LOG.debug((Object)("sending to user (" + this.recipient + ") the message: " + message));
                this.chat.sendMessage(message);
            }
        }
        catch (XMPPException e) {
            LOG.error((Object)"Unable to send message via Jabber", (Throwable)e);
        }
    }

    protected abstract String createMessage(XMLLogHelper var1) throws CruiseControlException;
}

