/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.publishers.EmailPublisher;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.apache.tools.ant.launch.Locator;

public class HTMLEmailPublisher
extends EmailPublisher {
    private static final Logger LOG = Logger.getLogger(HTMLEmailPublisher.class);
    private String xslFile;
    private String xslDir;
    private String css;
    private String logDir;
    private String messageMimeType = "text/html";
    private String charset;
    private String[] xslFileNames = new String[]{"header.xsl", "buildresults.xsl"};
    private List xsltParameters = new LinkedList();

    public void validate() throws CruiseControlException {
        super.validate();
        if (this.logDir != null) {
            this.verifyDirectory("HTMLEmailPublisher.logDir", this.logDir);
        } else {
            LOG.debug((Object)"Using default logDir \"logs/<projectname>\"");
        }
        if (this.xslFile == null) {
            if (this.xslDir == null) {
                this.xslDir = this.getXslDirFromClasspath();
            }
            this.verifyDirectory("HTMLEmailPublisher.xslDir", this.xslDir);
            if (this.css == null) {
                this.css = this.getCssFromClasspath();
            }
            this.verifyFile("HTMLEmailPublisher.css", this.css);
            String[] fileNames = this.getXslFileNames();
            if (fileNames == null) {
                throw new CruiseControlException("HTMLEmailPublisher.getXslFileNames() can't return null");
            }
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                this.verifyFile("HTMLEmailPublisher.xslDir/" + fileName, new File(this.xslDir, fileName));
            }
        } else {
            this.verifyFile("HTMLEmailPublisher.xslFile", this.xslFile);
        }
    }

    public Property createParameter() {
        Property param = new Property();
        this.xsltParameters.add(param);
        return param;
    }

    private String getCssFromClasspath() {
        File cssFile = this.guessFileForResource("css/cruisecontrol.css");
        if (cssFile != null && cssFile.exists()) {
            return cssFile.getAbsolutePath();
        }
        return null;
    }

    private String getXslDirFromClasspath() {
        File xsl = this.guessFileForResource("xsl");
        if (xsl != null && xsl.isDirectory()) {
            return xsl.getAbsolutePath();
        }
        return null;
    }

    private File guessFileForResource(String relativeResource) {
        File ccHome = this.getCruiseRootDir();
        if (System.getProperty("cc.home") != null) {
            ccHome = new File(System.getProperty("cc.home"));
        }
        String cruise = "reporting/jsp/webcontent/";
        String binaryDistribution = "webapps/cruisecontrol/";
        File[] possiblePaths = new File[]{new File(this.getCruiseRootDir(), cruise + relativeResource), new File(this.getCruiseRootDir(), binaryDistribution + relativeResource), new File(ccHome, cruise + relativeResource), new File(ccHome, binaryDistribution + relativeResource)};
        for (int i = 0; i < possiblePaths.length; ++i) {
            if (!possiblePaths[i].exists()) continue;
            return possiblePaths[i];
        }
        return null;
    }

    private File getCruiseRootDir() {
        File classDir = Locator.getClassSource(this.getClass());
        if (classDir != null) {
            try {
                File rootDir = classDir.getParentFile().getParentFile().getParentFile();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("rootDir seems to be " + rootDir.getAbsolutePath() + " (classDir = " + classDir.getAbsolutePath() + ")"));
                }
                return rootDir;
            }
            catch (NullPointerException npe) {
                return null;
            }
        }
        return null;
    }

    private void verifyDirectory(String dirName, String dir) throws CruiseControlException {
        ValidationHelper.assertFalse(dir == null, dirName + " not specified in configuration file");
        File dirFile = new File(dir);
        ValidationHelper.assertTrue(dirFile.exists(), dirFile + " does not exist: " + dirFile.getAbsolutePath());
        ValidationHelper.assertTrue(dirFile.isDirectory(), dirFile + " is not a directory: " + dirFile.getAbsolutePath());
    }

    private void verifyFile(String fileName, String file) throws CruiseControlException {
        ValidationHelper.assertFalse(file == null, fileName + " not specified in configuration file");
        this.verifyFile(fileName, new File(file));
    }

    private void verifyFile(String fileName, File file) throws CruiseControlException {
        ValidationHelper.assertTrue(file.exists(), fileName + " does not exist: " + file.getAbsolutePath());
        ValidationHelper.assertTrue(file.isFile(), fileName + " is not a file: " + file.getAbsolutePath());
    }

    protected void addContentToMessage(String htmlContent, Message msg) throws MessagingException {
        MimeMultipart attachments = new MimeMultipart();
        MimeBodyPart textbody = new MimeBodyPart();
        String contentType = this.getContentType();
        textbody.setContent((Object)htmlContent, contentType);
        attachments.addBodyPart((BodyPart)textbody);
        msg.setContent((Multipart)attachments);
    }

    String getContentType() {
        if (this.charset != null) {
            return this.messageMimeType + "; charset=\"" + this.charset + "\"";
        }
        return this.messageMimeType;
    }

    public void setXSLFileList(String relativePathToXslFile) {
        if (relativePathToXslFile == null || relativePathToXslFile.equals("")) {
            throw new IllegalArgumentException("xslFileList shouldn't be null or empty");
        }
        boolean appending = (relativePathToXslFile = relativePathToXslFile.trim()).startsWith("+");
        if (appending) {
            relativePathToXslFile = relativePathToXslFile.substring(1);
        }
        StringTokenizer st = new StringTokenizer(relativePathToXslFile, " ,");
        int numTokens = st.countTokens();
        int i = appending ? this.xslFileNames.length : 0;
        String[] newXSLFileNames = new String[i + numTokens];
        System.arraycopy(this.xslFileNames, 0, newXSLFileNames, 0, i);
        while (st.hasMoreTokens()) {
            newXSLFileNames[i++] = st.nextToken();
        }
        this.setXSLFileNames(newXSLFileNames);
    }

    public void setXSLFile(String fullPathToXslFile) {
        this.xslFile = fullPathToXslFile;
    }

    public void setXSLDir(String xslDirectory) {
        this.xslDir = xslDirectory;
    }

    protected void setXSLFileNames(String[] fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException("xslFileNames can't be null (but can be empty)");
        }
        this.xslFileNames = fileNames;
    }

    protected String[] getXslFileNames() {
        return this.xslFileNames;
    }

    public void setCSS(String cssFilename) {
        this.css = cssFilename;
    }

    public void setLogDir(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("logDir cannot be null!");
        }
        this.logDir = directory;
    }

    public void setCharset(String characterSet) {
        this.charset = characterSet;
    }

    protected String createMessage(XMLLogHelper logHelper) {
        String message = "";
        File inFile = null;
        try {
            if (this.logDir == null) {
                this.logDir = "logs" + File.separator + logHelper.getProjectName();
            }
            inFile = new File(this.logDir, logHelper.getLogFileName());
            message = this.transform(inFile);
        }
        catch (Exception ex) {
            LOG.error((Object)("error transforming " + (inFile == null ? null : inFile.getAbsolutePath())), (Throwable)ex);
            try {
                String logFileName = logHelper.getLogFileName();
                message = this.createLinkLine(logFileName);
            }
            catch (CruiseControlException ccx) {
                LOG.error((Object)"exception getting logfile name", (Throwable)ccx);
            }
        }
        return message;
    }

    protected String transform(File inFile) throws TransformerException, FileNotFoundException, IOException {
        StringBuffer messageBuffer = new StringBuffer();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (this.xslFile != null) {
            File xslFileAsFile = new File(this.xslFile);
            this.appendTransform(inFile, messageBuffer, tFactory, xslFileAsFile);
        } else {
            this.appendHeader(messageBuffer);
            messageBuffer.append(this.createLinkLine(inFile.getName()));
            File xslDirectory = new File(this.xslDir);
            String[] fileNames = this.getXslFileNames();
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                File xsl = new File(xslDirectory, fileName);
                messageBuffer.append("<p>\n");
                this.appendTransform(inFile, messageBuffer, tFactory, xsl);
            }
            this.appendFooter(messageBuffer);
        }
        return messageBuffer.toString();
    }

    protected String createLinkLine(String logFileName) {
        StringBuffer linkLine = new StringBuffer("");
        String buildResultsURL = this.getBuildResultsURL();
        if (buildResultsURL == null) {
            return "";
        }
        int startName = logFileName.lastIndexOf(File.separator) + 1;
        int endName = logFileName.lastIndexOf(".");
        String baseLogFileName = logFileName.substring(startName, endName);
        StringBuffer url = new StringBuffer(buildResultsURL);
        if (buildResultsURL.indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("log=");
        url.append(baseLogFileName);
        linkLine.append("View results here -> <a href=\"");
        linkLine.append(url);
        linkLine.append("\">");
        linkLine.append(url);
        linkLine.append("</a>");
        return linkLine.toString();
    }

    protected void appendTransform(File inFile, StringBuffer messageBuffer, TransformerFactory tFactory, File xsl) {
        try {
            String result = this.transformFile(new StreamSource(inFile), tFactory, new StreamSource(xsl));
            messageBuffer.append(result);
        }
        catch (Exception e) {
            LOG.error((Object)("error transforming with xslFile " + xsl.getName()), (Throwable)e);
        }
    }

    protected String transformFile(Source logFile, TransformerFactory tFactory, Source xsl) throws IOException, TransformerException {
        Transformer transformer = tFactory.newTransformer(xsl);
        CharArrayWriter writer = new CharArrayWriter();
        if (!this.xsltParameters.isEmpty()) {
            for (Property param : this.xsltParameters) {
                transformer.setParameter(param.getName(), param.getValue());
            }
        }
        transformer.transform(logFile, new StreamResult(writer));
        return writer.toString();
    }

    protected void appendHeader(StringBuffer messageBuffer) throws IOException {
        messageBuffer.append("<html><head>\n");
        String baseUrl = this.getBuildResultsURL();
        if (baseUrl != null) {
            messageBuffer.append("<base href=\"").append(baseUrl).append("\">\n");
        }
        messageBuffer.append("<style>\n");
        Util.appendFileToBuffer(this.css, messageBuffer);
        messageBuffer.append("\n</style>\n</head><body>\n");
    }

    protected void appendFooter(StringBuffer messageBuffer) {
        messageBuffer.append("\n</body></html>");
    }
}

