/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapper;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapperHelper;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapping;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmailPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(EmailPublisher.class);
    private String mailHost;
    private String userName;
    private String password;
    private String mailPort;
    private boolean useSSL;
    private String buildResultsURL;
    private static final Always[] EMPTY_ALWAYS_ADDRESSES = new Always[0];
    private Always[] alwaysAddresses = EMPTY_ALWAYS_ADDRESSES;
    private static final Failure[] EMPTY_FAILURE_ADDRESSES = new Failure[0];
    private Failure[] failureAddresses = EMPTY_FAILURE_ADDRESSES;
    private static final Success[] EMPTY_SUCCESS_ADDRESSES = new Success[0];
    private Success[] successAddresses = EMPTY_SUCCESS_ADDRESSES;
    private static final Alert[] EMPTY_ALERT_ADDRESSES = new Alert[0];
    private Alert[] alertAddresses = EMPTY_ALERT_ADDRESSES;
    private static final Ignore[] EMPTY_IGNORE_ADDRESSES = new Ignore[0];
    private Ignore[] ignoreUsers = EMPTY_IGNORE_ADDRESSES;
    private static final EmailMapper[] EMPTY_EMAIL_MAPPERS = new EmailMapper[0];
    private EmailMapper[] emailMapper = EMPTY_EMAIL_MAPPERS;
    private final EmailMapperHelper mapperHelper = new EmailMapperHelper();
    private String returnAddress;
    private String returnName;
    private String defaultSuffix = "";
    private String reportSuccess = "always";
    private boolean spamWhileBroken = true;
    private boolean skipUsers = false;
    private String subjectPrefix;
    private boolean failAsImportant = true;

    protected abstract String createMessage(XMLLogHelper var1);

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getMailHost(), "mailhost", this.getClass());
        ValidationHelper.assertIsSet((Object)this.getReturnAddress(), "returnaddress", this.getClass());
        ValidationHelper.assertFalse(this.getUsername() != null && this.getPassword() == null, "'password' is required if 'username' is set for email.");
        ValidationHelper.assertFalse(this.getPassword() != null && this.getUsername() == null, "'username' is required if 'password' is set for email.");
        this.validateAddresses(this.alwaysAddresses);
        this.validateAddresses(this.alertAddresses);
        this.validateAddresses(this.failureAddresses);
        this.validateAddresses(this.successAddresses);
        for (int i = 0; i < this.ignoreUsers.length; ++i) {
            this.ignoreUsers[i].validate();
        }
    }

    private void validateAddresses(Address[] addresses) throws CruiseControlException {
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i].validate();
        }
    }

    protected String createSubject(XMLLogHelper logHelper) throws CruiseControlException {
        StringBuffer subjectLine = new StringBuffer();
        if (this.subjectPrefix != null) {
            subjectLine.append(this.subjectPrefix).append(" ");
        }
        subjectLine.append(logHelper.getProjectName());
        if (logHelper.isBuildSuccessful()) {
            String label = logHelper.getLabel();
            if (label.trim().length() > 0) {
                subjectLine.append(" ").append(logHelper.getLabel());
            }
            if (logHelper.isBuildFix()) {
                subjectLine.append(" Build Fixed");
            } else {
                subjectLine.append(" Build Successful");
            }
        } else {
            subjectLine.append(" Build Failed");
        }
        return subjectLine.toString();
    }

    protected boolean shouldSend(XMLLogHelper logHelper) throws CruiseControlException {
        if (logHelper.isBuildSuccessful()) {
            if (this.reportSuccess.equalsIgnoreCase("always")) {
                return true;
            }
            if (this.reportSuccess.equalsIgnoreCase("fixes")) {
                if (logHelper.wasPreviousBuildSuccessful()) {
                    LOG.debug((Object)"reportSuccess is set to 'fixes', not sending emails for repeated successful builds.");
                    return false;
                }
                return true;
            }
            if (this.reportSuccess.equalsIgnoreCase("never")) {
                LOG.debug((Object)"reportSuccess is set to 'never', not sending emails for successful builds.");
                return false;
            }
        } else if (!logHelper.wasPreviousBuildSuccessful() && logHelper.isBuildNecessary() && !this.spamWhileBroken) {
            LOG.debug((Object)"spamWhileBroken is set to false, not sending email");
            return false;
        }
        return true;
    }

    protected String createUserList(XMLLogHelper logHelper) throws CruiseControlException {
        Set<String> emails = this.createUserSet(logHelper);
        return this.createEmailString(emails);
    }

    protected Set<String> createUserSet(XMLLogHelper logHelper) throws CruiseControlException {
        int i;
        Set<Object> users = this.skipUsers ? new HashSet() : logHelper.getBuildParticipants();
        for (i = 0; i < this.ignoreUsers.length; ++i) {
            users.remove(this.ignoreUsers[i].getUser());
        }
        for (i = 0; i < this.alwaysAddresses.length; ++i) {
            users.add(this.alwaysAddresses[i].getAddress());
        }
        if (!logHelper.isBuildSuccessful()) {
            for (i = 0; i < this.failureAddresses.length; ++i) {
                users.add(this.failureAddresses[i].getAddress());
            }
        }
        if (logHelper.isBuildFix()) {
            for (i = 0; i < this.failureAddresses.length; ++i) {
                if (!this.failureAddresses[i].shouldReportWhenFixed()) continue;
                users.add(this.failureAddresses[i].getAddress());
            }
        }
        if (logHelper.isBuildSuccessful()) {
            for (i = 0; i < this.successAddresses.length; ++i) {
                users.add(this.successAddresses[i].getAddress());
            }
        }
        TreeSet<String> emails = new TreeSet<String>();
        this.mapperHelper.mapUsers(this, users, emails);
        for (String email : emails) {
            if (this.isValid(email)) continue;
            LOG.warn((Object)("Invalid email: " + email));
        }
        return emails;
    }

    boolean isValid(String address) {
        return EmailValidator.getInstance().isValid(address);
    }

    @Override
    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        boolean important = this.failAsImportant && !helper.isBuildSuccessful();
        HashSet<String> userSet = new HashSet<String>();
        Set<String> alertSet = this.createAlertUserSet(helper);
        String subject = this.createSubject(helper);
        if (!alertSet.isEmpty()) {
            String alertSubject = "[MOD ALERT] " + subject;
            this.sendMail(this.createEmailString(alertSet), alertSubject, this.createMessage(helper), important);
        }
        if (this.shouldSend(helper)) {
            userSet.addAll(this.createUserSet(helper));
            userSet.removeAll(alertSet);
            if (!userSet.isEmpty()) {
                this.sendMail(this.createEmailString(userSet), subject, this.createMessage(helper), important);
            } else if (alertSet.isEmpty()) {
                LOG.info((Object)"No recipients, so not sending email");
            }
        }
    }

    protected Properties getMailProperties() {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.mailHost);
        props.put("mail.smtp.sendpartial", "true");
        if (this.mailPort != null) {
            props.put("mail.smtp.port", this.mailPort);
        }
        LOG.debug((Object)("mailHost is " + this.mailHost + ", mailPort is " + (this.mailPort == null ? "default" : this.mailPort)));
        if (this.userName != null && this.password != null) {
            props.put("mail.smtp.auth", "true");
            if (this.useSSL) {
                if (this.mailPort != null) {
                    props.put("mail.smtp.socketFactory.port", this.mailPort);
                }
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
        }
        return props;
    }

    protected boolean sendMail(String toList, String subject, String message, boolean important) throws CruiseControlException {
        boolean emailSent = false;
        if (toList != null && toList.trim().length() != 0) {
            LOG.debug((Object)("Sending email to: " + toList));
            Session session = Session.getDefaultInstance((Properties)this.getMailProperties(), null);
            session.setDebug(LOG.isDebugEnabled());
            try {
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((javax.mail.Address)this.getFromAddress());
                msg.setRecipients(Message.RecipientType.TO, (javax.mail.Address[])InternetAddress.parse((String)toList, (boolean)false));
                msg.setSubject(subject);
                msg.setSentDate(new Date());
                String importance = important ? "High" : "Normal";
                msg.addHeader("Importance", importance);
                this.addContentToMessage(message, (Message)msg);
                if (this.userName != null && this.password != null) {
                    msg.saveChanges();
                    Transport transport = session.getTransport("smtp");
                    transport.connect(this.mailHost, this.userName, this.password);
                    transport.sendMessage((Message)msg, msg.getAllRecipients());
                    transport.close();
                } else {
                    Transport.send((Message)msg);
                }
                emailSent = true;
            }
            catch (SendFailedException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (MessagingException e) {
                throw new CruiseControlException(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), e);
            }
        }
        return emailSent;
    }

    protected void addContentToMessage(String content, Message msg) throws MessagingException {
        msg.setText(content);
    }

    protected InternetAddress getFromAddress() throws AddressException {
        InternetAddress fromAddress = new InternetAddress(this.returnAddress);
        if (this.returnName != null) {
            try {
                fromAddress = new InternetAddress(this.returnAddress, this.returnName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("error setting returnName [" + this.returnName + "]: " + e.getMessage()));
            }
        }
        return fromAddress;
    }

    public void setMailHost(String hostname) {
        this.mailHost = hostname;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setUsername(String name) {
        this.userName = name;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMailPort(String port) {
        this.mailPort = port;
    }

    public String getMailPort() {
        return this.mailPort;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setSubjectPrefix(String prefix) {
        this.subjectPrefix = prefix;
    }

    public String getSubjectPrefix() {
        return this.subjectPrefix;
    }

    public String getBuildResultsURL() {
        return this.buildResultsURL;
    }

    public void setBuildResultsURL(String url) {
        this.buildResultsURL = url;
    }

    public EmailMapper[] getEmailMapper() {
        return this.emailMapper;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String emailAddress) {
        this.returnAddress = emailAddress;
    }

    public String getReturnName() {
        return this.returnName;
    }

    public void setReturnName(String emailReturnName) {
        this.returnName = emailReturnName;
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String defaultEmailSuffix) {
        this.defaultSuffix = defaultEmailSuffix;
    }

    public void setReportSuccess(String report) {
        this.reportSuccess = report;
    }

    public void setSkipUsers(boolean skip) {
        this.skipUsers = skip;
    }

    public void setSpamWhileBroken(boolean spam) {
        this.spamWhileBroken = spam;
    }

    public void setFailAsImportant(boolean important) {
        this.failAsImportant = important;
    }

    public Ignore createIgnore() {
        ArrayList<Ignore> ignoreList = new ArrayList<Ignore>();
        ignoreList.addAll(Arrays.asList(this.ignoreUsers));
        Ignore ignore = new Ignore();
        ignoreList.add(ignore);
        this.ignoreUsers = ignoreList.toArray(new Ignore[ignoreList.size()]);
        return ignore;
    }

    public Always createAlways() {
        ArrayList<Always> alwaysList = new ArrayList<Always>();
        alwaysList.addAll(Arrays.asList(this.alwaysAddresses));
        Always always = new Always();
        alwaysList.add(always);
        this.alwaysAddresses = alwaysList.toArray(new Always[alwaysList.size()]);
        return always;
    }

    public Failure createFailure() {
        ArrayList<Failure> failureList = new ArrayList<Failure>();
        failureList.addAll(Arrays.asList(this.failureAddresses));
        Failure failure = new Failure();
        failureList.add(failure);
        this.failureAddresses = failureList.toArray(new Failure[failureList.size()]);
        return failure;
    }

    public Success createSuccess() {
        ArrayList<Success> successList = new ArrayList<Success>();
        successList.addAll(Arrays.asList(this.successAddresses));
        Success success = new Success();
        successList.add(success);
        this.successAddresses = successList.toArray(new Success[successList.size()]);
        return success;
    }

    public Alert createAlert() {
        ArrayList<Alert> alertsList = new ArrayList<Alert>();
        alertsList.addAll(Arrays.asList(this.alertAddresses));
        Alert alert = new Alert();
        alertsList.add(alert);
        this.alertAddresses = alertsList.toArray(new Alert[alertsList.size()]);
        return alert;
    }

    public void add(EmailMapping mapping) {
        EmailMapperHelper.addCacheEntry(this, mapping.getAlias(), mapping.getAddress());
    }

    public void add(EmailMapper mapper) {
        ArrayList<EmailMapper> mapperList = new ArrayList<EmailMapper>();
        mapperList.addAll(Arrays.asList(this.emailMapper));
        mapper.setPublisher(this);
        mapperList.add(mapper);
        this.emailMapper = mapperList.toArray(new EmailMapper[mapperList.size()]);
    }

    protected String createAlertUserList(XMLLogHelper logHelper) {
        return this.createEmailString(this.createAlertUserSet(logHelper));
    }

    protected Set<String> createAlertUserSet(XMLLogHelper logHelper) {
        if (this.alertAddresses.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        Set<Modification> modificationSet = logHelper.getModifications();
        for (Modification mod : modificationSet) {
            String modifiedFile = mod.getFullPath();
            LOG.debug((Object)("Modified file: " + modifiedFile));
            for (int i = 0; i < this.alertAddresses.length; ++i) {
                String emailAddress = this.alertAddresses[i].getAddress();
                if (emailAddress == null || "".equals(emailAddress.trim()) || users.contains(emailAddress) || !this.matchRegExpr(modifiedFile, this.alertAddresses[i].fileFilter)) continue;
                users.add(emailAddress);
                LOG.info((Object)("Alert '" + emailAddress + "' because their fileRegExpr '" + this.alertAddresses[i].fileRegExpr + "' matched " + modifiedFile));
            }
        }
        TreeSet<String> emails = new TreeSet<String>();
        this.mapperHelper.mapUsers(this, users, emails);
        return emails;
    }

    protected String createEmailString(Set<String> emails) {
        StringBuffer commaDelimitedString = new StringBuffer();
        Iterator<String> emailIterator = this.appendDefaultSuffix(emails).iterator();
        while (emailIterator.hasNext()) {
            String mappedUser = emailIterator.next();
            commaDelimitedString.append(mappedUser);
            if (!emailIterator.hasNext()) continue;
            commaDelimitedString.append(",");
        }
        LOG.debug((Object)("List of emails: " + commaDelimitedString));
        return commaDelimitedString.toString();
    }

    private Set<String> appendDefaultSuffix(Set emails) {
        TreeSet<String> result = new TreeSet<String>();
        for (String mappedUser : emails) {
            if (mappedUser.indexOf("@") < 0) {
                mappedUser = mappedUser + this.defaultSuffix;
            }
            result.add(mappedUser);
        }
        return result;
    }

    protected boolean matchRegExpr(String input, GlobFilenameFilter pattern) {
        File file = new File(input);
        String path = file.toString();
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        return pattern.accept(file, path);
    }

    public static class Alert
    extends Address {
        private static final long serialVersionUID = 3644326033589789766L;
        private String fileRegExpr = null;
        private GlobFilenameFilter fileFilter = null;

        public void validate() throws CruiseControlException {
            super.validate();
            ValidationHelper.assertIsSet((Object)this.fileRegExpr, "fileregexpr", this.getClass());
            try {
                this.fileFilter = new GlobFilenameFilter(this.fileRegExpr);
            }
            catch (MalformedCachePatternException mcpe) {
                ValidationHelper.fail("invalid regexp '" + this.fileRegExpr + "'", (Exception)((Object)mcpe));
            }
        }

        public void setFileRegExpr(String f) {
            this.fileRegExpr = f;
        }
    }

    public static class Success
    extends Address {
        private static final long serialVersionUID = 8001068483405344504L;
    }

    public static class Failure
    extends Address {
        private static final long serialVersionUID = -6027290532428946586L;
        private boolean reportWhenFixed = false;

        public boolean shouldReportWhenFixed() {
            return this.reportWhenFixed;
        }

        public void setReportWhenFixed(boolean reportWhenFixed) {
            this.reportWhenFixed = reportWhenFixed;
        }
    }

    public static class Always
    extends Address {
        private static final long serialVersionUID = -4906620821397147420L;
    }

    public static class Address
    implements Serializable {
        private static final long serialVersionUID = -7143350548506511400L;
        private String address;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String theAddress) {
            this.address = theAddress;
        }

        public void validate() throws CruiseControlException {
            ValidationHelper.assertIsSet((Object)this.address, "address", this.getClass());
            ValidationHelper.assertFalse(this.address.equals(""), "empty string is not a valid value of address for " + this.getClass().getName());
        }
    }

    public static class Ignore
    implements Serializable {
        private static final long serialVersionUID = 4763763343885476189L;
        private String user;

        public String getUser() {
            return this.user;
        }

        public void validate() throws CruiseControlException {
            ValidationHelper.assertIsSet((Object)this.user, "user", this.getClass());
        }

        public void setUser(String theUser) {
            this.user = theUser;
        }
    }
}

