/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.CMSynergyPublisher;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class CMSynergyTaskPublisher
extends CMSynergyPublisher {
    private static final Logger LOG = Logger.getLogger(CMSynergyTaskPublisher.class);
    private String folderNumber;
    private String folderName;

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setFolderNumber(String folderNumber) {
        this.folderNumber = folderNumber;
    }

    public void publish(Element log) throws CruiseControlException {
        if (!this.shouldPublish(log)) {
            return;
        }
        if (this.folderNumber == null) {
            this.folderNumber = this.getFolderNumber(this.folderName, this.getProject());
        }
        StringBuffer tasks = new StringBuffer();
        List newTasksList = this.getNewTasks(log);
        Iterator newTasks = newTasksList.iterator();
        int index = 0;
        while (newTasks.hasNext()) {
            if (index > 0) {
                tasks.append(",");
            }
            tasks.append(newTasks.next());
            ++index;
        }
        LOG.info((Object)("Copying " + newTasksList.size() + " task(s) into folder " + this.folderNumber + "."));
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.getCcmExe(), this.getSessionName(), this.getSessionFile());
        cmd.createArgument("folder");
        cmd.createArgument("-modify");
        cmd.createArguments("-add_tasks", tasks.toString());
        cmd.createArgument(this.folderNumber);
        try {
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            throw new CruiseControlException("Failed to copy new tasks to folder " + this.folderNumber, e);
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.folderNumber == null && this.folderName == null, "Must specify either 'folderName' or 'folderNumber'");
        ValidationHelper.assertFalse(this.folderName != null && this.getProject() == null, "'project' attribute must be set when using the 'folderName' attribute.");
    }

    private String getFolderNumber(String folderName, String project) throws CruiseControlException {
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.getCcmExe(), this.getSessionName(), this.getSessionFile());
        cmd.createArgument("reconfigure_properties");
        cmd.createArgument("-u");
        cmd.createArgument("-f");
        cmd.createArgument("%description@#@#@#@%name");
        cmd.createArguments("-show", "folders");
        cmd.createArgument(project);
        try {
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            throw new CruiseControlException("Could not get a list of folders in project " + project, e);
        }
        for (String line : cmd.getStdoutAsList()) {
            if (line.indexOf(folderName) <= -1) continue;
            int index = line.indexOf("@#@#@#@");
            if (index == -1) {
                LOG.warn((Object)("Bad format in result: \"" + line + "\""));
                continue;
            }
            return line.substring(index += "@#@#@#@".length()).trim();
        }
        throw new CruiseControlException("Could not find a folder matching \"" + folderName + "\" in project \"" + project + "\".");
    }
}

