/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public abstract class CMSynergyPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(CMSynergyPublisher.class);
    private File sessionFile;
    private String sessionName;
    private String projectSpec;
    private String ccmExe;

    public void setSessionFile(String sessionFile) {
        this.sessionFile = new File(sessionFile);
    }

    public File getSessionFile() {
        return this.sessionFile;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setProject(String projectSpec) {
        this.projectSpec = projectSpec;
    }

    public String getProject() {
        return this.projectSpec;
    }

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public String getCcmExe() {
        return this.ccmExe;
    }

    private boolean isBuildSuccessful(Element log) {
        XMLLogHelper helper = new XMLLogHelper(log);
        return helper.isBuildSuccessful();
    }

    public Properties getBuildProperties(Element log) {
        Properties buildProperties = new Properties();
        for (Element property : log.getChild("info").getChildren("property")) {
            buildProperties.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
        }
        return buildProperties;
    }

    public List getNewTasks(Element log) {
        ArrayList<String> taskList = new ArrayList<String>();
        Element modifications = log.getChild("modifications");
        if (modifications != null) {
            for (Element modification : modifications.getChildren("modification")) {
                String task;
                String type = modification.getAttributeValue("type");
                if (type == null || !type.equals("ccmtask") || (task = modification.getChild("task").getText()) == null) continue;
                taskList.add(task.trim());
            }
        }
        return taskList;
    }

    public boolean shouldPublish(Element log) {
        if (!this.isBuildSuccessful(log)) {
            LOG.info((Object)"Build failed. Skipping publisher.");
            return false;
        }
        List newTasks = this.getNewTasks(log);
        if (newTasks.size() < 1) {
            LOG.info((Object)"No new CM Synergy tasks in build. Skipping publisher.");
            return false;
        }
        return true;
    }

    public double getVersion() {
        double version = 0.0;
        ManagedCommandline versionCmd = CMSynergy.createCcmCommand(this.getCcmExe(), this.getSessionName(), this.getSessionFile());
        versionCmd.clearArgs();
        versionCmd.createArgument("version");
        versionCmd.createArgument("-c");
        try {
            versionCmd.execute();
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not get Synergy version", (Throwable)e);
        }
        String versionString = versionCmd.getStdoutAsString();
        String[] versionList = versionString.split("\r\n|\r|\n");
        version = Double.parseDouble(versionList[versionList.length - 1]);
        return version;
    }
}

