/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.CMSynergyPublisher;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;

public class CMSynergyBaselinePublisher
extends CMSynergyPublisher {
    public static final String CCM_BASELINE_PURPOSE = "Integration Testing";
    public static final String CCM_BASELINE_STATE = "published_baseline";
    private static final Logger LOG = Logger.getLogger(CMSynergyBaselinePublisher.class);
    private static final Pattern LOG_PROPERTY_PATTERN;
    private String purpose = "Integration Testing";
    private String name;
    private String description;
    private String build;
    private String state = "published_baseline";

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setBaselineName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void publish(Element log) throws CruiseControlException {
        if (!this.shouldPublish(log)) {
            return;
        }
        Properties logProperties = this.getBuildProperties(log);
        String baselineName = null;
        if (this.name != null) {
            baselineName = this.parsePropertiesInString(this.name, logProperties);
        }
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.getCcmExe(), this.getSessionName(), this.getSessionFile());
        cmd.createArgument("baseline");
        cmd.createArgument("-create");
        if (baselineName != null) {
            cmd.createArgument(baselineName);
        }
        if (this.description != null) {
            cmd.createArguments("-description", this.description);
        }
        cmd.createArguments("-release", this.getProjectRelease());
        cmd.createArguments("-purpose", this.purpose);
        cmd.createArguments("-project", this.getProject());
        cmd.createArgument("-subprojects");
        double version = this.getVersion();
        if (version >= 6.4 & !this.build.equals(null)) {
            cmd.createArguments("-build", this.build);
        }
        if (version >= 6.4) {
            cmd.createArguments("-state", this.state);
        }
        try {
            LOG.info((Object)"Creating Synergy baseline...");
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            StringBuffer error = new StringBuffer("Failed to create intermediate baseline for project \"");
            error.append(this.getProject());
            error.append("\".");
            throw new CruiseControlException(error.toString(), e);
        }
        StringBuffer message = new StringBuffer("Created baseline");
        if (baselineName != null) {
            message.append(" ").append(baselineName);
        }
        message.append(".");
        LOG.info((Object)message.toString());
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getProject(), "project", this.getClass());
    }

    public String getProjectRelease() throws CruiseControlException {
        String release;
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.getCcmExe(), this.getSessionName(), this.getSessionFile());
        cmd.createArgument("attribute");
        cmd.createArguments("-show", "release");
        cmd.createArguments("-project", this.getProject());
        try {
            cmd.execute();
            cmd.assertExitCode(0);
            release = cmd.getStdoutAsString().trim();
        }
        catch (Exception e) {
            throw new CruiseControlException("Could not determine the release value of project \"" + this.getProject() + "\".", e);
        }
        return release;
    }

    public String getProjectRelease(String project, String sessionName) throws CruiseControlException {
        String release;
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.getCcmExe(), sessionName, this.getSessionFile());
        cmd.createArgument("attribute");
        cmd.createArguments("-show", "release");
        cmd.createArguments("-project", project);
        try {
            cmd.execute();
            cmd.assertExitCode(0);
            release = cmd.getStdoutAsString().trim();
        }
        catch (Exception e) {
            throw new CruiseControlException("Could not determine the release value of project \"" + project + "\".", e);
        }
        return release;
    }

    private String parsePropertiesInString(String string, Properties buildProperties) {
        Perl5Matcher matcher = new Perl5Matcher();
        while (matcher.contains(string, LOG_PROPERTY_PATTERN)) {
            MatchResult result = matcher.getMatch();
            String pre = result.group(1);
            String propertyName = result.group(2);
            String post = result.group(3);
            String value = buildProperties.getProperty(propertyName);
            if (value == null) {
                LOG.warn((Object)("Could not resolve property \"" + propertyName + "\"."));
                value = "_";
            }
            string = pre + value + post;
        }
        return string;
    }

    static {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            LOG_PROPERTY_PATTERN = compiler.compile("(.*)\\@\\{([^@{}]+)\\}(.*)");
        }
        catch (MalformedPatternException e) {
            LOG.fatal((Object)"Error compiling pattern for property matching", (Throwable)e);
            throw new IllegalStateException();
        }
    }
}

