/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.builders.AbstractAntBuilderDelegate;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPublisher
extends AbstractAntBuilderDelegate
implements Publisher {
    private static final Logger LOG = Logger.getLogger(AntPublisher.class);

    @Override
    public void publish(Element log) throws CruiseControlException {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.populatePropertesForAntBuilder(log, properties);
        Element result = this.getDelegate().build(properties, null);
        if (result == null) {
            LOG.error((Object)"Publisher failed.\n\n");
        } else {
            Attribute error = result.getAttribute("error");
            if (error == null) {
                LOG.info((Object)"Publisher successful.");
            } else {
                LOG.error((Object)("Publisher failed.\n\n" + error.getValue() + "\n"));
            }
        }
    }

    void populatePropertesForAntBuilder(Element log, Map<String, String> properties) {
        XMLLogHelper helper = new XMLLogHelper(log);
        if (helper.isBuildSuccessful()) {
            properties.put("thisbuildsuccessful", "true");
        } else {
            properties.put("thisbuildsuccessful", "false");
        }
        for (Object o : log.getChild("info").getChildren("property")) {
            Element property = (Element)o;
            properties.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
        }
    }
}

