/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.logmanipulators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.cruisecontrol.logmanipulators.BaseManipulator;
import net.sourceforge.cruisecontrol.util.IO;
import org.apache.log4j.Logger;

public class GZIPManipulator
extends BaseManipulator {
    private static final Logger LOG = Logger.getLogger(GZIPManipulator.class);
    private static final int BUFFER_SIZE = 4096;

    public void execute(String logDir) {
        File[] filesToGZip = this.getRelevantFiles(logDir, false);
        for (int i = 0; i < filesToGZip.length; ++i) {
            File file = filesToGZip[i];
            this.gzipFile(file, logDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzipFile(File logfile, String logDir) {
        String fileName = logfile.getName() + ".gz";
        try {
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(new File(logDir, fileName)));
            try {
                FileInputStream in = new FileInputStream(logfile);
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                    ((OutputStream)out).flush();
                }
                finally {
                    IO.close(in);
                }
            }
            finally {
                IO.close(out);
            }
            logfile.delete();
        }
        catch (IOException e) {
            LOG.warn((Object)("could not gzip " + logfile.getName() + ": " + e.getMessage()), (Throwable)e);
        }
    }
}

