/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.logmanipulators;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.cruisecontrol.logmanipulators.BaseManipulator;
import net.sourceforge.cruisecontrol.util.IO;
import org.apache.log4j.Logger;

public class DeleteArtifactsManipulator
extends BaseManipulator {
    private static final Logger LOG = Logger.getLogger(DeleteArtifactsManipulator.class);
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss");

    protected FilenameFilter getFilenameFilter(Date logdate, boolean ignoreSuffix) {
        return new ArtifactFilter(logdate);
    }

    public void execute(String logDir) {
        File[] deleteFiles = this.getRelevantFiles(logDir, true);
        for (int i = 0; i < deleteFiles.length; ++i) {
            LOG.debug((Object)("Deleting artifacts directory: " + deleteFiles[i].getAbsolutePath()));
            IO.delete(deleteFiles[i]);
        }
    }

    private class ArtifactFilter
    implements FilenameFilter {
        private final Date logdate;

        public ArtifactFilter(Date logdate) {
            this.logdate = logdate;
        }

        public boolean accept(File dir, String name) {
            Date artifactDirDate;
            if (name.startsWith("log")) {
                return false;
            }
            try {
                artifactDirDate = FORMATTER.parse(name);
            }
            catch (ParseException e) {
                return false;
            }
            if (artifactDirDate.before(this.logdate)) {
                File checkArtifactDir = new File(dir, name);
                return checkArtifactDir.exists() && checkArtifactDir.isDirectory();
            }
            return false;
        }
    }
}

