/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.listeners;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class LockFileListener
implements Listener {
    private static final Logger LOG = Logger.getLogger(LockFileListener.class);
    private String path;
    private String projectName;

    public void handleEvent(ProjectEvent event) throws CruiseControlException {
        if (!(event instanceof ProjectStateChangedEvent)) {
            return;
        }
        if (!ProjectState.IDLE.equals(((ProjectStateChangedEvent)event).getNewState())) {
            return;
        }
        File lock = new File(this.path);
        String message = "Project " + event.getProjectName() + " failed to delete lock file " + this.path;
        if (!lock.exists()) {
            LOG.debug((Object)message);
            LOG.debug((Object)"Lockfile didn't exist");
            return;
        }
        String nameInLockFile = this.getFileContents(lock);
        if (!this.projectName.equalsIgnoreCase(nameInLockFile)) {
            LOG.debug((Object)message);
            LOG.debug((Object)("Content (" + nameInLockFile + ") didn't match projectName attribute (" + this.projectName + ")"));
            return;
        }
        boolean deletedFile = this.attemptToDeleteLock();
        if (!deletedFile) {
            throw new CruiseControlException(message);
        }
    }

    String getFileContents(File lock) throws CruiseControlException {
        String nameInLockFile;
        try {
            nameInLockFile = Util.readFileToString(lock);
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        return nameInLockFile;
    }

    boolean attemptToDeleteLock() {
        return new File(this.path).delete();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.path, "lockfile", LockFileListener.class);
        ValidationHelper.assertIsSet((Object)this.projectName, "projectName", LockFileListener.class);
    }

    public void setLockFile(String path) {
        this.path = path;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }
}

