/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.listeners;

import java.io.File;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.listeners.ProgressChangedEvent;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.util.CurrentBuildFileWriter;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CurrentBuildStatusListener
implements Listener {
    private static final Logger LOG = Logger.getLogger(CurrentBuildStatusListener.class);
    private String fileName;
    public static final String MSG_PREFIX_PROGRESS = "progress: ";

    public void handleEvent(ProjectEvent event) throws CruiseControlException {
        if (event instanceof ProjectStateChangedEvent) {
            ProjectStateChangedEvent stateChanged = (ProjectStateChangedEvent)event;
            ProjectState newState = stateChanged.getNewState();
            LOG.debug((Object)("updating status to " + newState.getName() + " for project " + stateChanged.getProjectName()));
            String text = newState.getDescription() + " since\n";
            CurrentBuildFileWriter.writefile(text, new Date(), this.fileName);
        } else if (event instanceof ProgressChangedEvent) {
            ProgressChangedEvent progressChanged = (ProgressChangedEvent)event;
            String msgProgress = DateUtil.formatIso8601(progressChanged.getProgress().getLastUpdated()) + " " + progressChanged.getProgress().getText();
            LOG.debug((Object)("updating progress to " + msgProgress + " for project " + progressChanged.getProjectName()));
            String text = this.getStatusTextPrefix() + MSG_PREFIX_PROGRESS + msgProgress;
            IO.write(this.fileName, text);
        } else {
            LOG.debug((Object)("ignoring event " + event.getClass().getName() + " for project " + event.getProjectName()));
        }
    }

    private String getStatusTextPrefix() throws CruiseControlException {
        String line;
        String statusPrefix = "";
        File statusFile = new File(this.fileName);
        if (!statusFile.exists()) {
            return statusPrefix;
        }
        List lines = IO.readLines(statusFile);
        for (int i = 0; i < lines.size() && !(line = (String)lines.get(i)).startsWith(MSG_PREFIX_PROGRESS); ++i) {
            statusPrefix = statusPrefix + line + "\n";
        }
        return statusPrefix;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.fileName, "file", this.getClass());
        CurrentBuildFileWriter.validate(this.fileName);
    }

    public void setFile(String fileName) {
        this.fileName = fileName.trim();
        LOG.debug((Object)("set fileName = " + fileName));
    }
}

