/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.listeners;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.listeners.CurrentBuildStatusListener;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.util.AbstractFTPClass;
import net.sourceforge.cruisecontrol.util.CurrentBuildFileWriter;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CurrentBuildStatusFTPListener
extends AbstractFTPClass
implements Listener {
    private static final Logger LOG = Logger.getLogger(CurrentBuildStatusListener.class);
    private String fileName;
    private String destdir;

    public void handleEvent(ProjectEvent event) throws CruiseControlException {
        if (event instanceof ProjectStateChangedEvent) {
            String out;
            ProjectStateChangedEvent stateChanged = (ProjectStateChangedEvent)event;
            ProjectState newState = stateChanged.getNewState();
            LOG.debug((Object)("updating status to " + newState.getName() + " for project " + stateChanged.getProjectName()));
            String text = newState.getDescription() + " since\n";
            CurrentBuildFileWriter.writefile(text, new Date(), this.fileName);
            try {
                out = Util.readFileToString(this.fileName);
            }
            catch (IOException ioe) {
                throw new CruiseControlException(ioe.getMessage());
            }
            String fname = this.destdir + File.separator + this.fileName;
            this.sendFileToFTPPath(out, fname);
        } else {
            LOG.debug((Object)("ignoring event " + event.getClass().getName() + " for project " + event.getProjectName()));
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.fileName, "file", this.getClass());
        CurrentBuildFileWriter.validate(this.fileName);
        ValidationHelper.assertIsSet((Object)this.destdir, "destdir", this.getClass());
        super.validate();
    }

    public void setFile(String fileName) {
        this.fileName = fileName.trim();
        LOG.debug((Object)("set fileName = " + fileName));
    }

    public void setDestDir(String dir) {
        this.destdir = dir;
        LOG.debug((Object)("set destdir = " + dir));
    }

    public String getFileName() {
        return this.fileName;
    }
}

