/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.launch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.launch.CruiseControlMain;
import net.sourceforge.cruisecontrol.launch.LaunchException;
import net.sourceforge.cruisecontrol.launch.util.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public static final String CCHOME_PROPERTY = "cc.home";
    public static final String CCDISTDIR_PROPERTY = "cc.dist.dir";
    public static final String CCLIBDIR_PROPERTY = "cc.library.dir";
    public static final String CC_PRIVATEDIR = ".cruisecontrol";
    public static final String CC_PRIVATELIB = "lib";
    public static final String USER_LIBDIR = ".cruisecontrol" + File.separator + "lib";
    public static final String USER_HOMEDIR = "user.home";
    public static final String MAIN_CLASS = "net.sourceforge.cruisecontrol.Main";
    public static final String ARG_LOG4J_CONFIG = "log4jconfig";
    static final String ERR_MSG_LOG4J_CONFIG = "The -log4jconfig argument must be followed by a log4j configuration URL (for example: \"file:/c:/mylog4j.xml\")";
    public static final String PROP_LOG4J_CONFIGURATION = "log4j.configuration";
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    public static final String SYSPROP_CCMAIN_SKIP_USAGE_EXIT = "cc.main.skip.usage.exit";
    static final String MSG_BAD_CCHOME = "CruiseControl home is not set or could not be located.";

    public static void main(String[] args) {
        try {
            Launcher launcher = new Launcher();
            launcher.run(args);
        }
        catch (LaunchException e) {
            System.err.println(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void run(String[] args) throws LaunchException, MalformedURLException {
        StringBuffer baseClassPath;
        File sourceJar = Locator.getClassSource(this.getClass());
        File distJarDir = sourceJar.getParentFile();
        File ccHome = this.getCCHomeDir(distJarDir);
        ArrayList<String> libPaths = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>();
        boolean noUserLib = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-lib")) {
                if (i == args.length - 1) {
                    throw new LaunchException("The -lib argument must be followed by a library location");
                }
                libPaths.add(args[++i]);
                continue;
            }
            if (args[i].equals("--nouserlib") || args[i].equals("-nouserlib")) {
                noUserLib = true;
                continue;
            }
            if (args[i].equals("-log4jconfig")) {
                if (i == args.length - 1) {
                    throw new LaunchException(ERR_MSG_LOG4J_CONFIG);
                }
                System.setProperty(PROP_LOG4J_CONFIGURATION, args[++i]);
                continue;
            }
            argList.add(args[i]);
        }
        ArrayList<URL> libPathURLs = new ArrayList<URL>();
        for (String libPath : libPaths) {
            this.addPath(libPath, true, libPathURLs);
        }
        URL[] libJars = libPathURLs.toArray(new URL[libPathURLs.size()]);
        File ccDistDir = null;
        String ccDistDirProperty = System.getProperty(CCDISTDIR_PROPERTY);
        if (ccDistDirProperty != null) {
            ccDistDir = new File(ccDistDirProperty);
        }
        if (ccDistDir == null || !ccDistDir.exists()) {
            ccDistDir = distJarDir;
            System.setProperty(CCDISTDIR_PROPERTY, ccDistDir.getAbsolutePath());
        }
        URL[] distJars = Locator.getLocationURLs(ccDistDir);
        File ccLibDir = null;
        String ccLibDirProperty = System.getProperty(CCLIBDIR_PROPERTY);
        if (ccLibDirProperty != null) {
            ccLibDir = new File(ccLibDirProperty);
        }
        if (ccLibDir == null || !ccLibDir.exists()) {
            ccLibDir = new File(ccHome, CC_PRIVATELIB);
            System.setProperty(CCLIBDIR_PROPERTY, ccLibDir.getAbsolutePath());
        }
        URL[] supportJars = Locator.getLocationURLs(ccLibDir);
        URL[] antJars = Locator.getLocationURLs(new File(ccLibDir, "ant"));
        File userLibDir = new File(System.getProperty(USER_HOMEDIR), USER_LIBDIR);
        URL[] userJars = noUserLib ? EMPTY_URL_ARRAY : Locator.getLocationURLs(userLibDir);
        File toolsJar = Locator.getToolsJar();
        int numJars = libJars.length + userJars.length + distJars.length + supportJars.length + antJars.length;
        if (toolsJar != null) {
            ++numJars;
        }
        URL[] jars = new URL[numJars];
        this.copyJarUrls(libJars, jars, 0);
        this.copyJarUrls(userJars, jars, libJars.length);
        this.copyJarUrls(distJars, jars, userJars.length + libJars.length);
        this.copyJarUrls(supportJars, jars, userJars.length + libJars.length + distJars.length);
        this.copyJarUrls(antJars, jars, userJars.length + libJars.length + distJars.length + supportJars.length);
        if (toolsJar != null) {
            jars[jars.length - 1] = toolsJar.toURI().toURL();
        }
        if ((baseClassPath = new StringBuffer(System.getProperty("java.class.path"))).charAt(baseClassPath.length() - 1) == File.pathSeparatorChar) {
            baseClassPath.setLength(baseClassPath.length() - 1);
        }
        for (URL jar : jars) {
            baseClassPath.append(File.pathSeparatorChar);
            baseClassPath.append(Locator.fromURI(jar.toString()));
        }
        baseClassPath.append(File.pathSeparatorChar);
        baseClassPath.append(".");
        baseClassPath.append(File.pathSeparatorChar);
        baseClassPath.append(ccHome.getAbsolutePath()).append(File.separatorChar);
        System.setProperty("java.class.path", baseClassPath.toString());
        System.out.println("Classpath: " + baseClassPath.toString());
        URLClassLoader loader = new URLClassLoader(jars);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> mainClass = loader.loadClass(MAIN_CLASS);
            CruiseControlMain main = (CruiseControlMain)mainClass.newInstance();
            boolean normalExit = main.start(argList.toArray(new String[argList.size()]));
            if (!normalExit) {
                this.exitWithErrorCode();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void exitWithErrorCode() {
        if (!Boolean.getBoolean(SYSPROP_CCMAIN_SKIP_USAGE_EXIT)) {
            System.exit(1);
        }
    }

    File getCCHomeDir(File distJarDir) throws LaunchException {
        File ccHome;
        String ccHomeProperty = System.getProperty(CCHOME_PROPERTY);
        if (ccHomeProperty != null && new File(ccHomeProperty).exists()) {
            ccHome = new File(ccHomeProperty);
        } else if (distJarDir.getParentFile() != null) {
            ccHome = distJarDir.getParentFile();
            System.setProperty(CCHOME_PROPERTY, ccHome.getAbsolutePath());
            System.out.println("WARNING: cc.home reset to " + System.getProperty(CCHOME_PROPERTY));
        } else {
            ccHome = null;
        }
        if (ccHome == null || !ccHome.exists()) {
            throw new LaunchException(MSG_BAD_CCHOME);
        }
        if (ccHomeProperty == null) {
            System.setProperty(CCHOME_PROPERTY, ccHome.toString());
        }
        return ccHome;
    }

    private void copyJarUrls(URL[] sourceArray, URL[] destinationArray, int destinationStartIndex) {
        System.arraycopy(sourceArray, 0, destinationArray, destinationStartIndex, sourceArray.length);
    }

    private void addPath(String path, boolean getJars, List<URL> libPathURLs) throws MalformedURLException {
        StringTokenizer myTokenizer = new StringTokenizer(path, System.getProperty("path.separator"));
        while (myTokenizer.hasMoreElements()) {
            String elementName = myTokenizer.nextToken();
            File element = new File(elementName);
            if (elementName.indexOf("%") != -1 && !element.exists()) continue;
            if (getJars && element.isDirectory()) {
                URL[] dirURLs = Locator.getLocationURLs(element);
                libPathURLs.addAll(Arrays.asList(dirURLs));
            }
            libPathURLs.add(element.toURI().toURL());
        }
    }
}

