/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.labelincrementers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class SVNLabelIncrementer
implements LabelIncrementer {
    private static final Logger LOG = Logger.getLogger(SVNLabelIncrementer.class);
    private String workingCopyPath = ".";
    private String labelPrefix = "svn";
    private String separator = ".";

    public boolean isPreBuildIncrementer() {
        return true;
    }

    public String incrementLabel(String oldLabel, Element buildLog) {
        String revisionNumber = "";
        String result = oldLabel;
        try {
            revisionNumber = this.getSvnRevision();
            if (revisionNumber == null || revisionNumber.equals("")) {
                return this.labelPrefix;
            }
            result = this.labelPrefix + this.getSeparator() + revisionNumber;
            if (oldLabel.indexOf(result) > -1) {
                int lastSeparator = oldLabel.lastIndexOf(this.getSeparator());
                int firstSeparator = oldLabel.indexOf(this.getSeparator());
                int lastPart = 1;
                if (lastSeparator != firstSeparator) {
                    String suffix = oldLabel.substring(lastSeparator + 1);
                    lastPart = Integer.parseInt(suffix) + 1;
                }
                result = result + this.getSeparator() + lastPart;
            }
            LOG.debug((Object)("Incrementing label from " + oldLabel + " to " + result));
        }
        catch (IOException e) {
            LOG.error((Object)"could not execute svn binary", (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("could not increment label. Old label was " + oldLabel + ". svn revision was " + revisionNumber), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSvnRevision() throws IOException {
        String rev;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"svnversion", this.workingCopyPath});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            rev = stdInput.readLine();
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        LOG.debug((Object)("SVN revision is: " + rev));
        return rev;
    }

    public boolean isValidLabel(String label) {
        return true;
    }

    public void setWorkingCopyPath(String path) {
        LOG.debug((Object)("Working Path is: " + path));
        this.workingCopyPath = path;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public String getDefaultLabel() {
        return this.getLabelPrefix() + this.getSeparator() + "0";
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

