/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.labelincrementers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.util.IO;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PropertyFileLabelIncrementer
implements LabelIncrementer {
    private static final Logger LOG = Logger.getLogger(PropertyFileLabelIncrementer.class);
    private String propertyFile;
    private String propertyName;
    private boolean preBuildIncrementer;
    private String defaultLabel;

    public String incrementLabel(String oldLabel, Element buildLog) {
        return this.getLabel();
    }

    public boolean isValidLabel(String label) {
        return true;
    }

    public boolean isPreBuildIncrementer() {
        return this.preBuildIncrementer;
    }

    public String getDefaultLabel() {
        return this.getLabel();
    }

    public void setPreBuildIncrementer(boolean preBuildIncrementer) {
        this.preBuildIncrementer = preBuildIncrementer;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private String getLabel() {
        String string;
        if (this.propertyFile == null) {
            throw new IllegalStateException("property file not specified");
        }
        if (!new File(this.propertyFile).isFile()) {
            String message = "property file does not exist: " + this.propertyFile;
            if (this.defaultLabel == null) {
                throw new IllegalStateException(message);
            }
            LOG.info((Object)message);
            LOG.info((Object)"using specified default label");
            return this.defaultLabel;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.propertyFile);
            Properties p = new Properties();
            p.load(is);
            String label = p.getProperty(this.propertyName);
            LOG.info((Object)("Retrieved label " + label));
            string = label;
        }
        catch (IOException ex) {
            try {
                String msg = "Unable to retrieve label " + ex.getMessage();
                LOG.error((Object)msg, (Throwable)ex);
                throw new RuntimeException(msg);
            }
            catch (Throwable throwable) {
                IO.close(is);
                throw throwable;
            }
        }
        IO.close(is);
        return string;
    }

    public void setDefaultLabel(String defaultLabel) {
        if (defaultLabel == null) {
            throw new IllegalArgumentException("null is not valid as the default label");
        }
        if ("".equals(defaultLabel)) {
            throw new IllegalArgumentException("empty string is not valid as the default label");
        }
        this.defaultLabel = defaultLabel;
    }
}

