/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.labelincrementers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.jdom.Element;

public class P4ChangelistLabelIncrementer
implements LabelIncrementer {
    private static final Logger LOG = Logger.getLogger(P4ChangelistLabelIncrementer.class);
    private static final String CHANGELIST_PREFIX = "@";
    private static final String REVISION_PREFIX = "#";
    private static final String RECURSE_U = "/...";
    private static final String RECURSE_W = "\\...";
    private String p4Port;
    private String p4Client;
    private String p4User;
    private String p4View;
    private String p4Passwd;
    private boolean clean = false;
    private boolean delete = false;
    private boolean sync = true;
    private int baseChangelist = -1;

    public String incrementLabel(String oldLabel, Element buildLog) {
        String label = null;
        try {
            boolean syncP4;
            this.validate();
            boolean delTree = this.delete;
            boolean cleanP4 = delTree || this.clean;
            boolean bl = syncP4 = cleanP4 || this.sync;
            if (cleanP4) {
                LOG.info((Object)("Cleaning Perforce clientspec " + this.p4Client));
                this.syncTo("#0");
            }
            if (delTree) {
                this.deleteView();
            }
            label = this.getDefaultLabel();
            if (syncP4) {
                this.syncTo(CHANGELIST_PREFIX + label);
            }
        }
        catch (CruiseControlException cce) {
            LOG.warn((Object)"Couldn't run expected tasks", (Throwable)cce);
        }
        return label;
    }

    public boolean isPreBuildIncrementer() {
        return true;
    }

    public boolean isValidLabel(String label) {
        return true;
    }

    public String getDefaultLabel() {
        if (this.baseChangelist > 0) {
            return Integer.toString(this.baseChangelist);
        }
        try {
            this.validate();
            return this.getCurrentChangelist();
        }
        catch (CruiseControlException cce) {
            cce.printStackTrace();
            LOG.fatal((Object)"Problem accessing Perforce changelist", (Throwable)cce);
            throw new IllegalStateException("Problem accessing Perforce changelist");
        }
    }

    public void setChangelist(int syncChange) {
        this.baseChangelist = syncChange;
    }

    public void setPort(String p4Port) {
        this.p4Port = p4Port;
    }

    public void setClient(String p4Client) {
        this.p4Client = p4Client;
    }

    public void setUser(String p4User) {
        this.p4User = p4User;
    }

    public void setView(String p4View) {
        this.p4View = p4View;
    }

    public void setPasswd(String p4Passwd) {
        this.p4Passwd = p4Passwd;
    }

    public void setNoSync(boolean b) {
        this.sync = !b;
    }

    public void setClean(boolean b) {
        this.clean = b;
    }

    public void setDelete(boolean b) {
        this.delete = b;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.p4View, "view", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4View, "view", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4Client, "client", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4Port, "port", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4User, "user", this.getClass());
        ValidationHelper.assertNotEmpty(this.p4Passwd, "passwd", this.getClass());
    }

    protected String getCurrentChangelist() throws CruiseControlException {
        Commandline cmd = this.buildBaseP4Command();
        cmd.createArgument("changes");
        cmd.createArgument("-m1");
        cmd.createArgument("-ssubmitted");
        ParseChangelistNumbers pcn = new ParseChangelistNumbers();
        this.runP4Cmd(cmd, pcn);
        String[] changes = pcn.getChangelistNumbers();
        if (changes != null && changes.length == 1) {
            return changes[0];
        }
        throw new CruiseControlException("Could not discover the changelist");
    }

    protected void syncTo(String viewArg) throws CruiseControlException {
        Commandline cmd = this.buildBaseP4Command();
        cmd.createArguments("sync", this.p4View + viewArg);
        this.runP4Cmd(cmd, new P4CmdParserAdapter());
    }

    protected void deleteView() throws CruiseControlException {
        try {
            Project p = this.createProject();
            FileSet fs = this.getWhereView(p);
            Delete d = this.createDelete(p);
            d.setProject(p);
            d.setVerbose(true);
            d.addFileset(fs);
            d.execute();
        }
        catch (BuildException be) {
            throw new CruiseControlException(be.getMessage(), be);
        }
    }

    protected FileSet getWhereView(Project p) throws CruiseControlException {
        String view = this.p4View;
        if (view == null) {
            view = "//...";
        }
        if (!view.endsWith(RECURSE_U) && !view.endsWith(RECURSE_W)) {
            LOG.debug((Object)("view [" + view + "] isn't recursive."));
            return null;
        }
        Commandline cmd = this.buildBaseP4Command();
        cmd.createArguments("where", view);
        ParseOutputParam pop = new ParseOutputParam("");
        this.runP4Cmd(cmd, pop);
        String[] values = pop.getValues();
        if (values == null || values.length <= 0) {
            LOG.debug((Object)"Didn't find any files for view");
            return null;
        }
        FileSet fs = this.createFileSet(p);
        fs.setDir(new File("/"));
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            PatternSet.NameEntry ne;
            String s = values[i];
            if (!s.endsWith(RECURSE_U) && !s.endsWith(RECURSE_W)) continue;
            String[] tokens = new String[3];
            int pos = 0;
            for (int j = 0; j < 3; ++j) {
                StringBuffer sb = new StringBuffer();
                boolean neot = true;
                while (neot && pos < s.length()) {
                    int q1 = s.indexOf(39, pos);
                    int q2 = s.indexOf(34, pos);
                    int sp = s.indexOf(32, pos);
                    if (!(q1 < 0 || q1 >= q2 && q2 >= 0 || q1 >= sp && sp >= 0)) {
                        sb.append(s.substring(pos, q1));
                        pos = q1 + 1;
                        continue;
                    }
                    if (!(q2 < 0 || q2 >= q1 && q1 >= 0 || q2 >= sp && sp >= 0)) {
                        sb.append(s.substring(pos, q2));
                        pos = q2 + 1;
                        continue;
                    }
                    if (sp >= 0) {
                        String sub = s.substring(pos, sp);
                        pos = sp + 1;
                        sb.append(sub);
                        if (sub.endsWith(RECURSE_U) || sub.endsWith(RECURSE_W)) {
                            neot = false;
                            continue;
                        }
                        sb.append(' ');
                        continue;
                    }
                    sb.append(s.substring(pos));
                    neot = false;
                }
                tokens[j] = new String(sb).trim();
            }
            if (tokens[0] == null || tokens[1] == null || tokens[2] == null || !tokens[2].endsWith(RECURSE_U) && !tokens[2].endsWith(RECURSE_W)) continue;
            String f = tokens[2].substring(0, tokens[2].length() - RECURSE_W.length()) + File.separator + "**";
            if (tokens[0].startsWith("-//")) {
                ne = fs.createExclude();
                ne.setName(f);
            } else {
                ne = fs.createInclude();
                ne.setName(f);
            }
            ++count;
        }
        if (count > 0) {
            return fs;
        }
        LOG.debug((Object)"no files in view to delete");
        return null;
    }

    protected Project createProject() {
        Project p = new Project();
        p.init();
        return p;
    }

    protected Delete createDelete(Project p) throws CruiseControlException {
        Task o = p.createTask("delete");
        if (o == null || !(o instanceof Delete)) {
            LOG.info((Object)"Could not find <delete> task in Ant.  Defaulting to basic constructor.");
            Delete d = new Delete();
            d.setProject(p);
            o = d;
        }
        return (Delete)o;
    }

    protected FileSet createFileSet(Project p) throws CruiseControlException {
        Object o = p.createDataType("fileset");
        if (o == null || !(o instanceof FileSet)) {
            LOG.info((Object)"Could not find <fileset> type in Ant.  Defaulting to basic constructor.");
            FileSet fs = new FileSet();
            fs.setProject(p);
            o = fs;
        }
        return (FileSet)o;
    }

    protected Commandline buildBaseP4Command() {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("p4");
        commandLine.createArgument("-s");
        if (this.p4Client != null) {
            commandLine.createArguments("-c", this.p4Client);
        }
        if (this.p4Port != null) {
            commandLine.createArguments("-p", this.p4Port);
        }
        if (this.p4User != null) {
            commandLine.createArguments("-u", this.p4User);
        }
        if (this.p4Passwd != null) {
            commandLine.createArguments("-P", this.p4Passwd);
        }
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runP4Cmd(Commandline cmd, P4CmdParser parser) throws CruiseControlException {
        try {
            Process p = cmd.execute();
            try {
                Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p));
                stderr.start();
                InputStream p4Stream = p.getInputStream();
                this.parseStream(p4Stream, parser);
                stderr.join();
            }
            finally {
                p.waitFor();
                IO.close(p);
            }
        }
        catch (IOException e) {
            throw new CruiseControlException("Problem trying to execute command line process", e);
        }
        catch (InterruptedException e) {
            throw new CruiseControlException("Problem trying to execute command line process", e);
        }
    }

    protected void parseStream(InputStream stream, P4CmdParser parser) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("error:")) {
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("exit: 0")) {
                LOG.debug((Object)"p4cmd: Found exit 0");
                break;
            }
            if (line.startsWith("exit:")) {
                LOG.error((Object)("p4cmd: Found exit " + line));
                throw new IOException("Error reading P4 stream: P4 says: " + line);
            }
            if (line.startsWith("warning:")) {
                parser.warning(line.substring(8));
                continue;
            }
            if (line.startsWith("info:") || line.startsWith("info1:")) {
                parser.info(line.substring(5));
                continue;
            }
            if (!line.startsWith("text:")) continue;
            parser.text(line.substring(5));
        }
        if (line == null) {
            throw new IOException("Error reading P4 stream: Unexpected EOF reached");
        }
    }

    protected static class ParseOutputParam
    extends P4CmdParserAdapter {
        private final String paramName;
        private List values = new ArrayList();

        public ParseOutputParam(String paramName) {
            this.paramName = paramName;
        }

        public void info(String msg) {
            String m = msg.trim();
            if (m.startsWith(this.paramName)) {
                String m2 = m.substring(this.paramName.length()).trim();
                this.values.add(m2);
            }
        }

        public String[] getValues() {
            String[] v = new String[]{};
            return this.values.toArray(v);
        }
    }

    protected static class ParseChangelistNumbers
    extends P4CmdParserAdapter {
        private ArrayList changelists = new ArrayList();

        protected ParseChangelistNumbers() {
        }

        public void info(String msg) {
            StringTokenizer st = new StringTokenizer(msg);
            st.nextToken();
            this.changelists.add(st.nextToken());
        }

        public String[] getChangelistNumbers() {
            String[] changelistNumbers = new String[]{};
            return this.changelists.toArray(changelistNumbers);
        }
    }

    protected static class P4CmdParserAdapter
    implements P4CmdParser {
        protected P4CmdParserAdapter() {
        }

        public void warning(String msg) {
        }

        public void info(String msg) {
        }

        public void text(String msg) {
        }
    }

    protected static interface P4CmdParser {
        public void warning(String var1);

        public void info(String var1);

        public void text(String var1);
    }
}

