/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.labelincrementers;

import net.sourceforge.cruisecontrol.LabelIncrementer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class DefaultLabelIncrementer
implements LabelIncrementer {
    private static final Logger LOG = Logger.getLogger(DefaultLabelIncrementer.class);
    private boolean preIncrement = false;
    private String separator = ".";
    private String defaultPrefix = "build";
    private int defaultSuffix = 1;
    private String defaultLabel = null;

    public String incrementLabel(String oldLabel, Element buildLog) {
        String prefix = oldLabel.substring(0, oldLabel.lastIndexOf(this.separator) + 1);
        String suffix = oldLabel.substring(oldLabel.lastIndexOf(this.separator) + 1, oldLabel.length());
        int i = Integer.parseInt(suffix);
        String newLabel = prefix + ++i;
        LOG.debug((Object)("Incrementing label: " + oldLabel + " -> " + newLabel));
        return newLabel;
    }

    public boolean isPreBuildIncrementer() {
        return this.preIncrement;
    }

    public void setPreBuildIncrementer(boolean preInc) {
        this.preIncrement = preInc;
    }

    public boolean isValidLabel(String label) {
        if (label.indexOf(this.separator) < 0) {
            return false;
        }
        try {
            String suffix = label.substring(label.lastIndexOf(this.separator) + 1, label.length());
            Integer.parseInt(suffix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setSeparator(String newSeparator) {
        this.separator = newSeparator;
    }

    public String getDefaultLabel() {
        if (this.defaultLabel != null) {
            int separatorIndex = this.defaultLabel.lastIndexOf(this.separator);
            if (separatorIndex == -1) {
                throw new IllegalStateException("separator \"" + this.separator + "\" not found in default Label " + this.defaultLabel);
            }
            this.defaultPrefix = this.defaultLabel.substring(0, separatorIndex);
            String suffix = this.defaultLabel.substring(separatorIndex + 1);
            this.defaultSuffix = Integer.parseInt(suffix);
            this.defaultLabel = null;
        }
        return this.defaultPrefix + this.separator + this.defaultSuffix;
    }

    public void setDefaultLabel(String label) {
        this.defaultLabel = label;
    }
}

